/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import javax.swing.AbstractListModel;
import org.limewire.collection.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferListModel<T>
extends AbstractListModel {
    private Buffer<T> buffer;

    public BufferListModel(int n) {
        this.buffer = new Buffer(n);
    }

    @Override
    public T getElementAt(int n) {
        return this.buffer.get(n);
    }

    @Override
    public int getSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getSize();
    }

    public void changeSize(int n) {
        if (n == 0) {
            int n2 = 0;
            if (this.buffer != null) {
                n2 = this.buffer.getSize();
            }
            this.buffer = null;
            this.fireContentsChanged(this, 0, n2);
            return;
        }
        Buffer<T> buffer = new Buffer<T>(n);
        for (int i = 0; this.buffer != null && i < Math.min(this.buffer.getSize(), n); ++i) {
            buffer.addFirst(this.buffer.get(i));
        }
        this.buffer = buffer;
    }

    public void removeAllElements() {
        if (this.buffer == null) {
            return;
        }
        this.buffer.clear();
        this.fireContentsChanged(this, 0, this.buffer.getCapacity());
    }

    public void addFirst(T t) {
        if (this.buffer == null) {
            return;
        }
        this.buffer.addFirst(t);
        this.fireContentsChanged(this, 0, this.buffer.getSize());
    }
}

