/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Component;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class LanguageFlagFactory {
    private static final Map<String, String> lc2cc = new HashMap<String, String>();

    public static ImageIcon getFlag(String string, String string2) {
        return LanguageFlagFactory.getFlag(string, string2, false);
    }

    public static ImageIcon getFlag(String string, String string2, boolean bl) {
        String string3;
        ImageIcon imageIcon = null;
        if (string != null && string.length() > 0) {
            try {
                imageIcon = GUIMediator.getThemeImage("flags/" + string.toUpperCase());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (imageIcon == null && (string3 = lc2cc.get(string2)) != null) {
            try {
                imageIcon = GUIMediator.getThemeImage("flags/" + string3);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (imageIcon == null) {
            imageIcon = GUIMediator.getThemeImage("globe" + (bl ? "_small" : "_large"));
        }
        return imageIcon;
    }

    public static ListCellRenderer getListRenderer() {
        return new LocaleRenderer();
    }

    static {
        lc2cc.put("en", "US");
        lc2cc.put("af", "ZA");
        lc2cc.put("am", "ET");
        lc2cc.put("ar", "EG");
        lc2cc.put("be", "BO");
        lc2cc.put("bg", "BG");
        lc2cc.put("bn", "BD");
        lc2cc.put("bo", "CN");
        lc2cc.put("br", "FR");
        lc2cc.put("bs", "BA");
        lc2cc.put("bu", "MM");
        lc2cc.put("ca", "ES");
        lc2cc.put("cs", "CZ");
        lc2cc.put("cy", "WE");
        lc2cc.put("da", "DK");
        lc2cc.put("de", "DE");
        lc2cc.put("dv", "MV");
        lc2cc.put("el", "GR");
        lc2cc.put("es", "ES");
        lc2cc.put("et", "EE");
        lc2cc.put("eu", "ES");
        lc2cc.put("fa", "IR");
        lc2cc.put("fi", "FI");
        lc2cc.put("fr", "FR");
        lc2cc.put("ga", "IE");
        lc2cc.put("gez", "ET");
        lc2cc.put("gu", "IN");
        lc2cc.put("gl", "ES");
        lc2cc.put("hi", "IN");
        lc2cc.put("hr", "HR");
        lc2cc.put("hu", "HU");
        lc2cc.put("hy", "AM");
        lc2cc.put("in", "ID");
        lc2cc.put("is", "IS");
        lc2cc.put("it", "IT");
        lc2cc.put("iw", "IL");
        lc2cc.put("ja", "JP");
        lc2cc.put("ka", "GG");
        lc2cc.put("kk", "KZ");
        lc2cc.put("kn", "IN");
        lc2cc.put("ks", "IN");
        lc2cc.put("ko", "KR");
        lc2cc.put("km", "KH");
        lc2cc.put("lb", "LU");
        lc2cc.put("lo", "LA");
        lc2cc.put("lt", "LT");
        lc2cc.put("lv", "LV");
        lc2cc.put("mg", "MG");
        lc2cc.put("mk", "MK");
        lc2cc.put("ml", "IN");
        lc2cc.put("mn", "MN");
        lc2cc.put("mr", "IN");
        lc2cc.put("ms", "MY");
        lc2cc.put("mt", "MT");
        lc2cc.put("ne", "NP");
        lc2cc.put("nl", "NL");
        lc2cc.put("nn", "NO");
        lc2cc.put("no", "NO");
        lc2cc.put("nb", "NO");
        lc2cc.put("or", "IN");
        lc2cc.put("pa", "IN");
        lc2cc.put("pl", "PL");
        lc2cc.put("pt", "PT");
        lc2cc.put("pu", "IN");
        lc2cc.put("ro", "RO");
        lc2cc.put("ru", "RU");
        lc2cc.put("si", "IN");
        lc2cc.put("sk", "SK");
        lc2cc.put("sl", "SI");
        lc2cc.put("sq", "AL");
        lc2cc.put("sr", "YU");
        lc2cc.put("LATN", "YU");
        lc2cc.put("sv", "SE");
        lc2cc.put("ta", "TA");
        lc2cc.put("te", "IN");
        lc2cc.put("tig", "ET");
        lc2cc.put("tg", "TJ");
        lc2cc.put("th", "TH");
        lc2cc.put("tl", "PH");
        lc2cc.put("tr", "TR");
        lc2cc.put("uk", "UA");
        lc2cc.put("ur", "PK");
        lc2cc.put("uz", "UZ");
        lc2cc.put("vi", "VN");
        lc2cc.put("zh", "CN");
    }

    private static class LocaleRenderer
    extends DefaultListCellRenderer {
        private LocaleRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Locale) {
                Locale locale = (Locale)object;
                this.setIcon(LanguageFlagFactory.getFlag(locale.getCountry(), locale.getLanguage()));
                this.setText(locale.getDisplayName(locale).substring(0, 1).toUpperCase() + locale.getDisplayName(locale).substring(1, locale.getDisplayName(locale).length()).toLowerCase());
            } else {
                this.setIcon(null);
            }
            this.setIconTextGap(10);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            return this;
        }
    }
}

