/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.bugs.SessionInfo;
import com.limegroup.gnutella.downloader.DiskController;
import org.limewire.net.SocketsManager;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.NIODispatcher;

@Singleton
public class LimeSessionInfo
implements SessionInfo {
    private final NIODispatcher dispatcher;
    private final DownloadManager downloadManager;
    private final Statistics statistics;
    private final ConnectionManager connectionManager;
    private final ContentManager contentManager;
    private final CreationTimeCache creationTimeCache;
    private final DiskController diskController;
    private final SocketsManager socketsManager;
    private final ByteBufferCache byteBufferCache;
    private final UDPService udpService;
    private final Acceptor acceptor;

    @Inject
    public LimeSessionInfo(NIODispatcher nIODispatcher, DownloadManager downloadManager, Statistics statistics, ConnectionManager connectionManager, ContentManager contentManager, CreationTimeCache creationTimeCache, DiskController diskController, SocketsManager socketsManager, ByteBufferCache byteBufferCache, UDPService uDPService, Acceptor acceptor) {
        this.dispatcher = nIODispatcher;
        this.downloadManager = downloadManager;
        this.statistics = statistics;
        this.connectionManager = connectionManager;
        this.contentManager = contentManager;
        this.creationTimeCache = creationTimeCache;
        this.diskController = diskController;
        this.socketsManager = socketsManager;
        this.byteBufferCache = byteBufferCache;
        this.udpService = uDPService;
        this.acceptor = acceptor;
    }

    public int getNumberOfPendingTimeouts() {
        return this.dispatcher.getNumPendingTimeouts();
    }

    public int getNumWaitingDownloads() {
        return this.downloadManager.getNumWaitingDownloads();
    }

    public int getNumIndividualDownloaders() {
        return this.downloadManager.getNumIndividualDownloaders();
    }

    public long getCurrentUptime() {
        return this.statistics.getUptime();
    }

    public int getNumUltrapeerToLeafConnections() {
        return this.connectionManager.getNumInitializedClientConnections();
    }

    public int getNumLeafToUltrapeerConnections() {
        return this.connectionManager.getNumClientSupernodeConnections();
    }

    public int getNumUltrapeerToUltrapeerConnections() {
        return this.connectionManager.getNumUltrapeerConnections();
    }

    public int getNumOldConnections() {
        return this.connectionManager.getNumOldConnections();
    }

    public long getContentResponsesSize() {
        return this.contentManager.getCacheSize();
    }

    public long getCreationCacheSize() {
        return this.creationTimeCache.getSize();
    }

    public long getDiskControllerByteCacheSize() {
        return this.diskController.getSizeOfByteCache();
    }

    public long getDiskControllerVerifyingCacheSize() {
        return this.diskController.getSizeOfVerifyingCache();
    }

    public int getDiskControllerQueueSize() {
        return this.diskController.getNumPendingItems();
    }

    public long getByteBufferCacheSize() {
        return this.byteBufferCache.getHeapCacheSize();
    }

    public int getNumberOfWaitingSockets() {
        return this.socketsManager.getNumWaitingSockets();
    }

    public boolean isGUESSCapable() {
        return this.udpService.isGUESSCapable();
    }

    public boolean canReceiveSolicited() {
        return this.udpService.canReceiveSolicited();
    }

    public boolean acceptedIncomingConnection() {
        return this.acceptor.acceptedIncoming();
    }

    public int getPort() {
        return this.acceptor.getPort(true);
    }
}

