/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BufferListModel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MonitorView
extends JPanel
implements ThemeObserver {
    private JCheckBox showQueriesCheckBox;
    private JTextField listSizeTextField;
    private JList listOfQueries;
    private JScrollPane scrollPane;
    private int listFixedSize;
    private static final int LIST_FIXED_SIZE_DEFAULT = 32;
    private boolean bypassCountChange = false;
    private BufferListModel<String> model = new BufferListModel(32);

    public MonitorView() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Monitor Window..."));
        int n = 6;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.showQueriesCheckBox = new JCheckBox(I18n.tr("Show Incoming Searches"));
        this.showQueriesCheckBox.setPreferredSize(new Dimension(200, 20));
        this.showQueriesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (MonitorView.this.listOfQueries != null) {
                    MonitorView.this.listOfQueries.setEnabled(MonitorView.this.showQueriesCheckBox.isSelected());
                }
                if (MonitorView.this.listSizeTextField != null) {
                    MonitorView.this.listSizeTextField.setEnabled(MonitorView.this.showQueriesCheckBox.isSelected());
                }
                if (itemEvent.getStateChange() == 1 && GuiCoreMediator.getConnectionServices().isShieldedLeaf()) {
                    GUIMediator.showMessage(I18n.tr("Your client is a leaf node shielded by an Ultrapeer. Hence you will see few or no searches in the monitor window."), QuestionsHandler.MONITOR_VIEW);
                }
            }
        });
        this.showQueriesCheckBox.setSelected(UISettings.UI_MONITOR_SHOW_INCOMING_SEARCHES.getValue());
        jPanel.add(this.showQueriesCheckBox);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(new JLabel(I18n.tr("Show Last")));
        jPanel.add(Box.createHorizontalStrut(n / 2));
        this.listFixedSize = 32;
        this.listSizeTextField = new WholeNumberField(this.listFixedSize, 3);
        Dimension dimension = new Dimension(16, 24);
        this.listSizeTextField.setPreferredSize(dimension);
        this.listSizeTextField.setMaximumSize(dimension);
        this.listSizeTextField.setEnabled(this.showQueriesCheckBox.isSelected());
        this.listSizeTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MonitorView.this.handleCountChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MonitorView.this.handleCountChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jPanel.add(this.listSizeTextField);
        jPanel.add(Box.createHorizontalStrut(n / 2));
        jPanel.add(new JLabel(I18n.tr("Searches")));
        this.listOfQueries = new JList<String>(this.model);
        this.listOfQueries.setPrototypeCellValue("                                      ");
        this.listOfQueries.setFixedCellHeight(16);
        this.listOfQueries.setEnabled(this.showQueriesCheckBox.isSelected());
        this.listOfQueries.setTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLER);
        this.listOfQueries.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() >= 2 && (n = MonitorView.this.listOfQueries.locationToIndex(mouseEvent.getPoint())) != -1) {
                    String string = (String)MonitorView.this.model.getElementAt(n);
                    GUIMediator.instance().triggerSearch(string);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.listOfQueries);
        this.scrollPane.setPreferredSize(new Dimension(340, 180));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n, n, n, n);
        gridBagConstraints.gridy = 0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, n, n, n);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.scrollPane.getViewport().setBackground(color);
        this.listOfQueries.setBackground(color);
    }

    private void handleCountChange() {
        if (this.bypassCountChange) {
            return;
        }
        String string = this.listSizeTextField.getText();
        if (string != null && !string.equals("")) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 1001;
            }
            if (n > 1000) {
                this.listFixedSize = 32;
                Runnable runnable = new Runnable(){

                    public void run() {
                        MonitorView.this.bypassCountChange = true;
                        MonitorView.this.listSizeTextField.setText(String.valueOf(MonitorView.this.listFixedSize));
                        MonitorView.this.bypassCountChange = false;
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                this.listFixedSize = n;
            }
            this.model.changeSize(this.listFixedSize);
            this.scrollPane.validate();
        }
    }

    public void handleQueryString(String string) {
        if (!this.showQueriesCheckBox.isSelected()) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        char c = string.charAt(string.length() - 1);
        if (Character.isISOControl(c) || !Character.isDefined(c)) {
            string = string.substring(0, string.length() - 1);
        }
        this.model.addFirst(string);
    }
}

