/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.TipOfTheDayMessages;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TipOfTheDayMediator
implements ThemeObserver {
    private static final int TIP_HEIGHT = 180;
    private static final int TIP_WIDTH = 360;
    private static TipOfTheDayMediator instance;
    private static final String TOTD_TITLE;
    private static final String TOTD_INTRO;
    private static final String TOTD_STARTUP;
    private static final String TOTD_NEXT;
    private static final String TOTD_PREVIOUS;
    private static final String TOTD_CLOSE;
    private final JDialog dialog;
    private final JEditorPane tipPane = new JEditorPane();
    private final JButton previousButton;
    private final List<String> messages;
    private static int _currentTip;
    private static Color _foreground;
    private boolean _canDisplay = true;

    private TipOfTheDayMediator() {
        this.dialog = new JDialog();
        this.messages = new ArrayList<String>();
        this.initializeMessages(this.messages);
        this.dialog.setModal(false);
        this.dialog.setResizable(true);
        this.dialog.setTitle(TOTD_TITLE);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                instance = null;
            }
        });
        this.previousButton = new JButton(TOTD_PREVIOUS);
        this.previousButton.addActionListener(new PreviousTipListener());
        this.constructDialog();
        ThemeMediator.addThemeObserver(this);
    }

    public static synchronized TipOfTheDayMediator instance() {
        if (instance == null) {
            instance = new TipOfTheDayMediator();
        }
        return instance;
    }

    public static synchronized boolean isConstructed() {
        return instance != null;
    }

    public void updateComponentTreeUI() {
        SwingUtilities.updateComponentTreeUI(this.dialog);
    }

    public void displayTipWindow() {
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                if (!TipOfTheDayMediator.this._canDisplay) {
                    return;
                }
                if (TipOfTheDayMediator.this.dialog.isShowing()) {
                    TipOfTheDayMediator.this.dialog.setVisible(false);
                    TipOfTheDayMediator.this.dialog.setVisible(true);
                    TipOfTheDayMediator.this.dialog.toFront();
                    return;
                }
                GUIUtils.centerOnScreen(TipOfTheDayMediator.this.dialog);
                TipOfTheDayMediator.this.dialog.setVisible(true);
                if (!"text/html".equals(TipOfTheDayMediator.this.tipPane.getContentType())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TipOfTheDayMediator.this.tipPane.setContentType("text/html");
                            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
                        }
                    });
                }
                TipOfTheDayMediator.this.dialog.toFront();
            }
        });
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    private void setText(String string) {
        String string2 = GUIUtils.colorToHex(_foreground);
        this.tipPane.setText("<html><font face='arial,helvetica,sanserif' color='#" + string2 + "'>" + string + "</font>");
        this.tipPane.setCaretPosition(0);
    }

    private void initializeMessages(List<String> list) {
        list.addAll(Arrays.asList(TipOfTheDayMessages.getGeneralMessages()));
        if (OSUtils.isWindows()) {
            list.addAll(Arrays.asList(TipOfTheDayMessages.getWindowsMessages()));
        } else if (OSUtils.isMacOSX()) {
            list.addAll(Arrays.asList(TipOfTheDayMessages.getMacOSXMessages()));
        } else if (OSUtils.isLinux()) {
            list.addAll(Arrays.asList(TipOfTheDayMessages.getLinuxMessages()));
        } else {
            list.addAll(Arrays.asList(TipOfTheDayMessages.getOtherMessages()));
        }
        if (!OSUtils.isMacOSX()) {
            list.addAll(Arrays.asList(TipOfTheDayMessages.getNonMacOSXMessages()));
        }
        if (LimeWireUtils.isPro()) {
            list.addAll(Arrays.asList(TipOfTheDayMessages.getProMessages()));
        } else {
            list.addAll(Arrays.asList(TipOfTheDayMessages.getBasicMessages()));
        }
        Collections.shuffle(list);
        _currentTip = -1;
    }

    private String getRandomTip() {
        if (this.messages.size() == 0) {
            throw new RuntimeException("No tips of the day");
        }
        if (_currentTip == this.messages.size() - 1) {
            Collections.shuffle(this.messages);
            _currentTip = -1;
        } else if (_currentTip < -1) {
            _currentTip = -1;
        }
        String string = this.messages.get(++_currentTip);
        if (_currentTip == 0) {
            this.previousButton.setEnabled(false);
        } else {
            this.previousButton.setEnabled(true);
        }
        return string;
    }

    @Override
    public void updateTheme() {
        boolean bl = this.dialog.isShowing();
        this.dialog.setVisible(false);
        this.dialog.getContentPane().removeAll();
        Font font = new Font(this.tipPane.getFont().getName(), this.tipPane.getFont().getStyle(), this.tipPane.getFont().getSize() - 2);
        this.tipPane.setFont(font);
        this.constructDialog();
        this.tipPane.setContentType("text/html");
        this.setText(this.getRandomTip());
        if (bl) {
            this.dialog.setVisible(true);
            this.dialog.toFront();
        }
    }

    private void constructDialog() {
        Color color = ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue().darker();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(color);
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createEtchedBorder(1));
        JLabel jLabel = new JLabel(GUIMediator.getThemeImage("question"));
        _foreground = jLabel.getForeground();
        jLabel.setOpaque(false);
        jLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.setBackground(UIManager.getColor("TextField.background"));
        jPanel2.setOpaque(true);
        JLabel jLabel2 = new JLabel(TOTD_INTRO);
        jLabel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        Font font = new Font("Dialog", jLabel2.getFont().getStyle(), jLabel2.getFont().getSize() + 5);
        jLabel2.setFont(font);
        jPanel2.add((Component)jLabel2, "North");
        this.tipPane.setContentType("text");
        this.tipPane.setEditable(false);
        Font font2 = new Font("Dialog", this.tipPane.getFont().getStyle(), this.tipPane.getFont().getSize() + 2);
        this.tipPane.setFont(font2);
        this.tipPane.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        this.tipPane.setText(I18n.tr("Loading tips..."));
        this.tipPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JScrollPane jScrollPane = new JScrollPane(this.tipPane);
        jScrollPane.setPreferredSize(new Dimension(360, 180));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setBorder(null);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JCheckBox jCheckBox = new JCheckBox(TOTD_STARTUP);
        jCheckBox.setSelected(StartupSettings.SHOW_TOTD.getValue());
        jPanel3.add(jCheckBox);
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(TOTD_NEXT);
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(TOTD_CLOSE);
        jPanel4.add(jButton2);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel3, "West");
        jPanel5.add((Component)jPanel4, "East");
        jCheckBox.addActionListener(new ShowTipListener());
        jButton.addActionListener(new NextTipListener());
        jButton2.addActionListener(GUIUtils.getDisposeAction());
        this.dialog.setDefaultCloseOperation(2);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel6.add((Component)jPanel, "Center");
        jPanel6.add((Component)jPanel5, "South");
        this.dialog.setContentPane(jPanel6);
        GUIUtils.addHideAction((JComponent)this.dialog.getContentPane());
        try {
            this.dialog.pack();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this._canDisplay = false;
        }
    }

    static {
        TOTD_TITLE = I18n.tr("Tip of the Day");
        TOTD_INTRO = I18n.tr("Did You Know...");
        TOTD_STARTUP = I18n.tr("Show Tips At Startup");
        TOTD_NEXT = I18n.tr("Next Tip");
        TOTD_PREVIOUS = I18n.tr("Previous Tip");
        TOTD_CLOSE = I18n.tr("Close");
    }

    private class PreviousTipListener
    implements ActionListener {
        private PreviousTipListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            _currentTip = _currentTip - 2;
            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
        }
    }

    private class NextTipListener
    implements ActionListener {
        private NextTipListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TipOfTheDayMediator.this.setText(TipOfTheDayMediator.this.getRandomTip());
        }
    }

    private class ShowTipListener
    implements ActionListener {
        private ShowTipListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            StartupSettings.SHOW_TOTD.setValue(jCheckBox.isSelected());
        }
    }
}

