/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import javax.swing.JComponent;

public class TorrentURITransferHandler
extends LimeTransferHandler {
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return DNDUtils.contains(dataFlavorArray, FileTransferable.URIFlavor);
    }

    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            URI[] uRIArray = DNDUtils.getURIs(transferable);
            if (this.areAllTorrentURLs(uRIArray)) {
                for (URI uRI : uRIArray) {
                    GUIMediator.instance().openTorrentURI(uRI);
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    boolean areAllTorrentURLs(URI[] uRIArray) {
        for (URI uRI : uRIArray) {
            String string = uRI.getScheme();
            if (string == null || !string.equalsIgnoreCase("http")) {
                return false;
            }
            String string2 = uRI.getPath();
            if (string2 != null && string2.toLowerCase(Locale.US).endsWith(".torrent")) continue;
            return false;
        }
        return true;
    }
}

