/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import com.limegroup.gnutella.gui.util.CoreExceptionHandler;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.limewire.util.OSUtils;

public class DownloaderDialog
extends JDialog {
    public static final int DEFAULT_ASK = 0;
    public static final int DEFAULT_APPEND = 1;
    public static final int DEFAULT_SAVE_AS = 2;
    private GuiDownloaderFactory factory;
    private Downloader downloader;
    private JLabel titleLabel = new JLabel();
    private JLabel descLabel = new JLabel();
    private JLabel noteLabel = new JLabel();
    private ButtonRow buttons;
    private File originalFile;

    DownloaderDialog(GuiDownloaderFactory guiDownloaderFactory, SaveLocationException saveLocationException) {
        super(GUIMediator.getAppFrame());
        this.factory = guiDownloaderFactory;
        this.originalFile = guiDownloaderFactory.getSaveFile();
        int n = QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue();
        if (n != 0) {
            if (n == 1) {
                new AppendAction().actionPerformed(new ActionEvent(this, 0, null));
            } else if (n == 2) {
                new SaveAsAction().actionPerformed(new ActionEvent(this, 0, null));
            }
            return;
        }
        this.setUpDialog(saveLocationException);
    }

    private void setUpDialog(SaveLocationException saveLocationException) {
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        Color color = UIManager.getColor("TextField.background");
        Color color2 = UIManager.getColor("TextField.foreground");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBackground(color);
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        JLabel jLabel = new JLabel(GUIMediator.getThemeImage("warning"));
        jLabel.setBackground(color);
        jLabel.setBorder(new EmptyBorder(2, 5, 2, 5));
        jPanel3.add((Component)jLabel, "West");
        this.titleLabel.setBackground(color);
        this.titleLabel.setForeground(color2);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        jPanel3.add((Component)this.titleLabel, "Center");
        jPanel2.add((Component)jPanel3, "North");
        Box box = Box.createVerticalBox();
        box.add(this.descLabel);
        box.add(Box.createVerticalStrut(10));
        box.add(this.noteLabel);
        box.add(Box.createVerticalStrut(5));
        box.add(Box.createVerticalGlue());
        jPanel2.add((Component)box, "Center");
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("Always Save As..."));
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("Always Append (#)"));
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("Always Ask"));
        this.setupDefaultOption(jRadioButton, 2);
        this.setupDefaultOption(jRadioButton2, 1);
        this.setupDefaultOption(jRadioButton3, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        JLabel jLabel2 = new JLabel(I18n.tr("Choose a Default Action:"));
        Box box2 = Box.createHorizontalBox();
        box2.add(jLabel2);
        box2.add(Box.createHorizontalGlue());
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalStrut(20));
        box3.add(jRadioButton3);
        box3.add(Box.createHorizontalStrut(15));
        box3.add(jRadioButton);
        box3.add(Box.createHorizontalStrut(15));
        box3.add(jRadioButton2);
        box3.add(Box.createHorizontalGlue());
        Box box4 = Box.createVerticalBox();
        box4.add(box2);
        box4.add(box3);
        box4.add(Box.createVerticalStrut(15));
        jPanel.add((Component)box4, "Center");
        this.buttons = new ButtonRow(new Action[]{new OverWriteAction(), new SaveAsAction(), new AppendAction(), new CancelAction()}, 0, 12);
        jPanel.add((Component)this.buttons, "South");
        this.setContentFromException(saveLocationException);
        this.pack();
    }

    private void setupDefaultOption(JRadioButton jRadioButton, final int n) {
        if (QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue() == n) {
            jRadioButton.setSelected(true);
        }
        jRadioButton.setFocusable(false);
        jRadioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.setValue(n);
                }
            }
        });
    }

    private void setLabel(JLabel jLabel, String string) {
        StringBuilder stringBuilder = new StringBuilder("<html><table><tr><td width=\"400\">");
        stringBuilder.append(string);
        stringBuilder.append("</td></tr></html>");
        jLabel.setText(stringBuilder.toString());
    }

    private void setContentFromException(SaveLocationException saveLocationException) {
        if (saveLocationException.getErrorCode() == 10) {
            this.dispose();
            DownloaderUtils.showIsAlreadyDownloadingWarning(this.factory);
            return;
        }
        if (this.buttons == null) {
            this.setUpDialog(saveLocationException);
            this.setLocationRelativeTo(MessageService.getParentComponent());
            this.setVisible(true);
            return;
        }
        String string = CoreExceptionHandler.getSaveLocationErrorString(saveLocationException, true);
        if (saveLocationException.getErrorCode() == 5) {
            this.setTitleLabel(MessageFormat.format(I18n.tr("Warning: {0}"), CoreExceptionHandler.getShortSaveLocationErrorString(saveLocationException)));
            this.setDescLabel(string);
        } else {
            this.setTitleLabel(MessageFormat.format(I18n.tr("Error: {0}"), CoreExceptionHandler.getShortSaveLocationErrorString(saveLocationException)));
            this.setDescLabel(string);
        }
        FileDesc fileDesc = DownloaderUtils.getFromLibrary(this.factory.getURN());
        if (fileDesc != null) {
            this.setNoteLabel(MessageFormat.format(I18n.tr("<b>Note</b>: A file with the same content already exists in the library at {0}"), "<i>" + GUIUtils.convertToNonBreakingSpaces(0, fileDesc.getFile().toString()) + "</i>"));
        }
        this.buttons.getButtonAtIndex(0).setVisible(saveLocationException.getErrorCode() == 5);
    }

    private void setTitleLabel(String string) {
        this.setTitle(string);
        this.titleLabel.setText(string);
    }

    private void setDescLabel(String string) {
        this.setLabel(this.descLabel, string);
    }

    private void setNoteLabel(String string) {
        this.setLabel(this.noteLabel, string);
    }

    public static Downloader handle(GuiDownloaderFactory guiDownloaderFactory, SaveLocationException saveLocationException) {
        if (saveLocationException.getErrorCode() == 10) {
            DownloaderUtils.showIsAlreadyDownloadingWarning(guiDownloaderFactory);
            return null;
        }
        int n = QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue();
        DownloaderDialog downloaderDialog = new DownloaderDialog(guiDownloaderFactory, saveLocationException);
        if (n == 0) {
            downloaderDialog.setLocationRelativeTo(MessageService.getParentComponent());
            downloaderDialog.setVisible(true);
        }
        return downloaderDialog.getDownloader();
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    void createUniqueFilenameDownloader() {
        String string;
        String string2 = string = this.originalFile.getName();
        String string3 = "";
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n);
        }
        Set<String> set = DownloadMediator.instance().getFileNames();
        File file = this.originalFile;
        String string4 = string;
        int n2 = 1;
        while (file.exists() || set.contains(string4)) {
            string4 = string2 + "(" + n2 + ")" + string3;
            file = new File(this.originalFile.getParent(), string4);
            ++n2;
        }
        try {
            this.factory.setSaveFile(file);
            this.downloader = this.factory.createDownloader(false);
            this.dispose();
        }
        catch (SaveLocationException saveLocationException) {
            this.setContentFromException(saveLocationException);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel the Download"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloaderDialog.this.dispose();
        }
    }

    private class AppendAction
    extends AbstractAction {
        public AppendAction() {
            this.putValue("Name", I18n.tr("Append (#)"));
            this.putValue("ShortDescription", I18n.tr("Appends (#) to filename"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DownloaderDialog.this.createUniqueFilenameDownloader();
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            this.putValue("Name", I18n.tr("Save As..."));
            this.putValue("ShortDescription", I18n.tr("Choose a different location for the Download"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = DownloaderUtils.showFileChooser(DownloaderDialog.this.factory, DownloaderDialog.this);
            if (file != null) {
                try {
                    DownloaderDialog.this.factory.setSaveFile(file);
                    DownloaderDialog.this.downloader = DownloaderDialog.this.factory.createDownloader(OSUtils.isAnyMac());
                    DownloaderDialog.this.dispose();
                }
                catch (SaveLocationException saveLocationException) {
                    DownloaderDialog.this.setContentFromException(saveLocationException);
                }
            }
        }
    }

    private class OverWriteAction
    extends AbstractAction {
        public OverWriteAction() {
            this.putValue("Name", I18n.tr("Overwrite"));
            this.putValue("ShortDescription", I18n.tr("Overwrite the Existing File"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DownloaderDialog.this.downloader = DownloaderDialog.this.factory.createDownloader(true);
                DownloaderDialog.this.dispose();
            }
            catch (SaveLocationException saveLocationException) {
                DownloaderDialog.this.setContentFromException(saveLocationException);
            }
        }
    }
}

