/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class iTunesMediator {
    private static final Log LOG = LogFactory.getLog(iTunesMediator.class);
    private static iTunesMediator INSTANCE;
    private final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("iTunesAdderThread");

    public static synchronized iTunesMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new iTunesMediator();
        }
        return INSTANCE;
    }

    private iTunesMediator() {
    }

    public void addSong(File file) {
        File[] fileArray;
        if (!OSUtils.isMacOSX()) {
            return;
        }
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("File: '" + file + "' does not exist");
            }
            return;
        }
        if (file.isDirectory()) {
            fileArray = FileUtils.getFilesRecursive(file, iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue());
        } else if (file.isFile() && iTunesMediator.isSupported(FileUtils.getFileExtension(file))) {
            fileArray = new File[]{file};
        } else {
            return;
        }
        for (File file2 : fileArray) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Will add '" + file2 + "' to Playlist");
            }
            this.QUEUE.execute(new ExecOSAScriptCommand(file2));
        }
    }

    private static boolean isSupported(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static String[] createOSAScriptCommand(File file) {
        String string = file.getAbsolutePath();
        String string2 = iTunesSettings.ITUNES_PLAYLIST.getValue();
        String[] stringArray = new String[]{"osascript", "-e", "tell application \"Finder\"", "-e", "set hfsFile to (POSIX file \"" + string + "\")", "-e", "set thePlaylist to \"" + string2 + "\"", "-e", "tell application \"iTunes\"", "-e", "launch", "-e", "if not (exists playlist thePlaylist) then", "-e", "set thisPlaylist to make new playlist", "-e", "set name of thisPlaylist to thePlaylist", "-e", "end if", "-e", "add hfsFile to playlist thePlaylist", "-e", "end tell", "-e", "end tell"};
        return stringArray;
    }

    private class ExecOSAScriptCommand
    implements Runnable {
        private final File file;

        public ExecOSAScriptCommand(File file) {
            this.file = file;
        }

        public void run() {
            try {
                Runtime.getRuntime().exec(iTunesMediator.createOSAScriptCommand(this.file));
            }
            catch (IOException iOException) {
                LOG.debug(iOException);
            }
        }
    }
}

