/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.gui.shell.LimeAssociations;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;

public class AssociationsWindow
extends SetupWindow {
    private Map<JCheckBox, LimeAssociationOption> associations = new HashMap<JCheckBox, LimeAssociationOption>();
    private JRadioButton always;
    private JRadioButton never;
    private JRadioButton ask;

    AssociationsWindow(SetupManager setupManager) {
        super(setupManager, I18nMarker.marktr("File & Protocol Associations"), I18nMarker.marktr("What type of resources should FrostWire open?"));
    }

    protected void createWindow() {
        super.createWindow();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(1, 4, 1, 0);
        for (LimeAssociationOption object2 : LimeAssociations.getSupportedAssociations()) {
            JCheckBox jCheckBox = new JCheckBox(object2.getDescription());
            jCheckBox.setSelected(true);
            this.associations.put(jCheckBox, object2);
            jPanel.add((Component)jCheckBox, gridBagConstraints);
        }
        gridBagConstraints.insets = new Insets(9, 3, 9, 3);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new Line(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(1, 0, 2, 0);
        jPanel.add((Component)new JLabel(I18n.tr("What should FrostWire do with the selected associations on startup?")), gridBagConstraints);
        int n = QuestionsHandler.GRAB_ASSOCIATIONS.getValue();
        this.always = new JRadioButton(I18n.tr("Always take the selected associations."), DialogOption.parseInt(n) == DialogOption.YES);
        this.never = new JRadioButton(I18n.tr("Ignore all missing associations."), DialogOption.parseInt(n) == DialogOption.NO);
        this.ask = new JRadioButton(I18n.tr("Ask me what to do when an association is missing."), DialogOption.parseInt(n) != DialogOption.YES && DialogOption.parseInt(n) != DialogOption.NO);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.always);
        buttonGroup.add(this.ask);
        buttonGroup.add(this.never);
        this.always.setSelected(true);
        gridBagConstraints.insets = new Insets(1, 4, 1, 0);
        jPanel.add((Component)this.always, gridBagConstraints);
        jPanel.add((Component)this.ask, gridBagConstraints);
        jPanel.add((Component)this.never, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridheight = 0;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        this.setSetupComponent(jPanel);
    }

    public void applySettings(boolean bl) {
        for (Map.Entry<JCheckBox, LimeAssociationOption> entry : this.associations.entrySet()) {
            LimeAssociationOption limeAssociationOption = entry.getValue();
            if (entry.getKey().isSelected()) {
                limeAssociationOption.setAllowed(true);
                limeAssociationOption.setEnabled(true);
                continue;
            }
            if (limeAssociationOption.isEnabled()) {
                limeAssociationOption.setAllowed(false);
            }
            limeAssociationOption.setEnabled(false);
        }
        Object object = DialogOption.INVALID;
        if (this.always.isSelected()) {
            object = DialogOption.YES;
        } else if (this.never.isSelected()) {
            object = DialogOption.NO;
        }
        QuestionsHandler.GRAB_ASSOCIATIONS.setValue(((DialogOption)((Object)object)).toInt());
    }
}

