/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.IncompleteDirectoryHolder;
import com.limegroup.gnutella.gui.library.LWSSpecialFilesHolder;
import com.limegroup.gnutella.gui.library.LibrarySearchPanel;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.library.RecursiveSharingDialog;
import com.limegroup.gnutella.gui.library.SavedFilesDirectoryHolder;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.sharing.ShareManager;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LibraryMediator
implements ThemeObserver {
    private static final JPanel MAIN_PANEL = new JPanel(new GridBagLayout());
    private static final CardLayout viewLayout = new CardLayout();
    private static final JPanel viewPanel = new JPanel(viewLayout);
    private static final LibraryTree LIBRARY_TREE = LibraryTree.instance();
    private static final JScrollPane TREE_SCROLL_PANE;
    private static final LibraryTableMediator LIBRARY_TABLE;
    private static final String TABLE_KEY = "LIBRARY_TABLE";
    private static final String SHARED_KEY = "SHARED";
    private final HandleFileUpdate FILE_UPDATER = new HandleFileUpdate();
    private static JPanel jpShared;
    private static JPanel storeShared;
    private static final LibraryMediator INSTANCE;

    public static LibraryMediator instance() {
        return INSTANCE;
    }

    private LibraryMediator() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Library Window..."));
        ThemeMediator.addThemeObserver(this);
        LibraryMediator.addView(LIBRARY_TABLE.getScrolledTablePane(), TABLE_KEY);
        JSplitPane jSplitPane = new JSplitPane(1, TREE_SCROLL_PANE, viewPanel);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(true);
        DividerLocationSettingUpdater.install(jSplitPane, UISettings.UI_LIBRARY_TREE_DIVIDER_LOCATION);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(LIBRARY_TREE.getButtonRow(), "West");
        jPanel.add((Component)LIBRARY_TABLE.getButtonRow(), "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        MAIN_PANEL.add((Component)new LibrarySearchPanel(GuiCoreMediator.getQueryRequestFactory()), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        MAIN_PANEL.add((Component)jSplitPane, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        MAIN_PANEL.add((Component)jPanel, gridBagConstraints);
        this.updateTheme();
        LIBRARY_TREE.setInitialSelection();
    }

    @Override
    public void updateTheme() {
        LIBRARY_TREE.updateTheme();
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        TREE_SCROLL_PANE.getViewport().setBackground(color);
    }

    public JComponent getComponent() {
        return MAIN_PANEL;
    }

    public void launchLibraryFile() {
        LIBRARY_TABLE.launch();
    }

    public void deleteLibraryFile() {
        LIBRARY_TABLE.removeSelection();
    }

    public void clearLibrary() {
        LIBRARY_TABLE.clearTable();
        LIBRARY_TREE.clear();
        this.quickRefresh();
    }

    public File getVisibleDirectory() {
        return LIBRARY_TREE.getSelectedDirectory();
    }

    public void quickRefresh() {
        DirectoryHolder directoryHolder = LIBRARY_TREE.getSelectedDirectoryHolder();
        if (directoryHolder instanceof SavedFilesDirectoryHolder || directoryHolder instanceof IncompleteDirectoryHolder || directoryHolder instanceof LWSSpecialFilesHolder) {
            LibraryMediator.updateTableFiles(directoryHolder);
        }
    }

    public void forceRefresh() {
        LibraryMediator.updateTableFiles(LIBRARY_TREE.getSelectedDirectoryHolder());
    }

    public void handleFileManagerEvent(FileManagerEvent fileManagerEvent) {
        LIBRARY_TREE.handleFileManagerEvent(fileManagerEvent);
        LIBRARY_TABLE.handleFileManagerEvent(fileManagerEvent, LIBRARY_TREE.getSelectedDirectoryHolder());
    }

    public void addSharedLibraryFolder() {
        File file = FileChooserHandler.getInputDirectory();
        if (file == null) {
            return;
        }
        this.addSharedLibraryFolder(file);
    }

    public void addSharedLibraryFolder(File file) {
        RecursiveSharingDialog recursiveSharingDialog;
        if (ShareManager.checkAndWarnNewSharedFolder(file) && (recursiveSharingDialog = new RecursiveSharingDialog((Frame)GUIMediator.getAppFrame(), file)).showChooseDialog(MessageService.getParentComponent()) == RecursiveSharingDialog.State.OK) {
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    GuiCoreMediator.getFileManager().addSharedFolders(recursiveSharingDialog.getRootsToShare(), recursiveSharingDialog.getFoldersToExclude());
                }
            });
        }
    }

    public void updateSharedFile(File file) {
        DirectoryHolder directoryHolder = LIBRARY_TREE.getSelectedDirectoryHolder();
        if (LIBRARY_TABLE.getTable().isShowing() && directoryHolder != null && directoryHolder.accept(file)) {
            this.FILE_UPDATER.addFileUpdate(file);
        }
    }

    public void setAnnotateEnabled(boolean bl) {
        LIBRARY_TABLE.setAnnotateEnabled(bl);
    }

    public void unshareLibraryFolder() {
        LIBRARY_TREE.unshareLibraryFolder();
    }

    void addFileToPlayList(File file) {
        GUIMediator.getPlayList().addFileToPlaylist(file);
    }

    void addFilesToPlayList(List<File> list) {
        GUIMediator.getPlayList().addFilesToPlaylist(list.toArray(new File[list.size()]));
    }

    static void updateTableFiles(DirectoryHolder directoryHolder) {
        LIBRARY_TABLE.updateTableFiles(directoryHolder);
        LibraryMediator.showView(TABLE_KEY);
    }

    public static boolean incompleteDirectoryIsSelected() {
        return LIBRARY_TREE.incompleteDirectoryIsSelected();
    }

    static boolean isRenameEnabled() {
        return !LIBRARY_TREE.searchResultDirectoryIsSelected() && !LIBRARY_TREE.incompleteDirectoryIsSelected();
    }

    public static void showSharedFiles() {
        if (jpShared == null) {
            jpShared = new JPanel(new BorderLayout());
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 6, 0);
            jPanel.add((Component)new JLabel(I18n.tr("You can configure the folders you share in FrostWire's Options.")), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)new JButton(new ConfigureOptionsAction("OPTIONS_SHARED_MAIN_TITLE", I18n.tr("Configure..."), I18n.tr("You can configure the folders you share in FrostWire's Options."))), gridBagConstraints);
            jpShared.add((Component)jPanel, "Center");
            jpShared.setBorder(BorderFactory.createEtchedBorder());
            LibraryMediator.addView(jpShared, SHARED_KEY);
        }
        LibraryMediator.showView(SHARED_KEY);
    }

    public static void showView(String string) {
        viewLayout.show(viewPanel, string);
    }

    public static void addView(Component component, String string) {
        viewPanel.add(component, string);
    }

    public static boolean setSelectedDirectory(File file) {
        return LIBRARY_TREE.setSelectedDirectory(file);
    }

    public static boolean setSelectedFile(File file) {
        boolean bl = LIBRARY_TREE.setSelectedDirectory(file.getParentFile());
        if (bl) {
            return LIBRARY_TABLE.setFileSelected(file);
        }
        return false;
    }

    public void setPlayerEnabled(boolean bl) {
        LIBRARY_TABLE.setPlayerEnabled(bl);
        LIBRARY_TREE.setPlayerEnabled(bl);
    }

    static {
        LIBRARY_TREE.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        TREE_SCROLL_PANE = new JScrollPane(LIBRARY_TREE);
        LIBRARY_TABLE = LibraryTableMediator.instance();
        jpShared = null;
        storeShared = null;
        INSTANCE = new LibraryMediator();
    }

    private static final class HandleFileUpdate
    implements Runnable {
        private Vector<File> list = new Vector();
        private boolean active = false;

        public void addFileUpdate(File file) {
            this.list.addElement(file);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.list.size() > 0) {
                    File file = this.list.firstElement();
                    this.list.removeElementAt(0);
                    LIBRARY_TABLE.update(file);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            finally {
                this.active = false;
            }
        }
    }
}

