/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.limewire.util.VersionUtils;

final class LibraryTableCellEditor
implements TableCellEditor {
    private JTextField _textField;
    private LibraryTableMediator _libraryTable;
    private CellEditorListener _cellEditorListener;
    private int lastRow = -1;
    static final EventObject EVENT = new EventObject(new Object());

    LibraryTableCellEditor(LibraryTableMediator libraryTableMediator) {
        this._libraryTable = libraryTableMediator;
    }

    public Object getCellEditorValue() {
        String string = this._textField.getText();
        return this._libraryTable.handleNameChange(string);
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            LimeJTable limeJTable = (LimeJTable)this._libraryTable.getTable();
            if (VersionUtils.isJava16OrAbove()) {
                if (limeJTable.getSelectedRow() == this.lastRow) {
                    return mouseEvent.getClickCount() < 2;
                }
                this.lastRow = limeJTable.getSelectedRow();
                return false;
            }
            return mouseEvent.getClickCount() < 2;
        }
        return eventObject == EVENT;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this._cellEditorListener = cellEditorListener;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this._cellEditorListener = null;
    }

    void fireEditingStopped() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    void fireEditingCanceled() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        LimeTextField limeTextField = new LimeTextField();
        limeTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTableCellEditor.this.fireEditingStopped();
            }
        });
        limeTextField.setText(object != null ? object.toString() : "");
        limeTextField.selectAll();
        limeTextField.setCaretPosition(0);
        limeTextField.requestFocus();
        this._textField = limeTextField;
        return limeTextField;
    }
}

