/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.dnd.CompositeTransferable;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.library.DirectoryHolder;
import com.limegroup.gnutella.gui.library.IncompleteDirectoryHolder;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.library.LibraryTreeTransferable;
import com.limegroup.gnutella.gui.library.SavedFilesDirectoryHolder;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

class LibraryTreeTransferHandler
extends LimeTransferHandler {
    LibraryTreeTransferHandler() {
        super(1);
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    protected Transferable createTransferable(JComponent jComponent) {
        LibraryTree libraryTree = (LibraryTree)jComponent;
        DirectoryHolder directoryHolder = libraryTree.getSelectedDirectoryHolder();
        List<File> list = FileTransferable.EMPTY_FILE_LIST;
        if (directoryHolder instanceof SavedFilesDirectoryHolder || directoryHolder instanceof IncompleteDirectoryHolder) {
            list = Arrays.asList(directoryHolder.getFiles());
        } else {
            File file = directoryHolder.getDirectory();
            if (file != null) {
                list = Collections.singletonList(file);
            }
        }
        if (list.isEmpty()) {
            return new LibraryTreeTransferable(directoryHolder);
        }
        return new CompositeTransferable(new LibraryTreeTransferable(directoryHolder), new FileTransferable(list));
    }
}

