/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.logging;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.logging.LogType;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.File;

public class LogEvent {
    private final long time = System.currentTimeMillis();
    private final LogType type;
    private final String message;

    public LogEvent(Downloader downloader) {
        this.type = LogType.DOWNLOAD;
        File file = downloader.getSaveFile();
        this.message = downloader.getAmountRead() == downloader.getContentLength() ? "<html>Download Finished - <b>" + (file == null ? "Unknown" : file.getName()) + "</b> <i>(" + GUIUtils.toUnitbytes(downloader.getContentLength()) + ")</i></html>" : "<html>Download Cancelled - <b>" + (file == null ? "Unknown" : file.getName()) + "</b> <i>(" + GUIUtils.toUnitbytes(downloader.getAmountRead()) + " of " + GUIUtils.toUnitbytes(downloader.getContentLength()) + ")</i></html>";
    }

    public LogEvent(Uploader uploader) {
        if (!uploader.getUploadType().isInternal()) {
            this.type = LogType.UPLOAD;
            this.message = "<html>Upload Started - <b>" + uploader.getFileName() + "</b> <i>(" + GUIUtils.toUnitbytes(uploader.getFileSize()) + ")</i></html>";
        } else if (uploader.getUploadType() == UploadType.BROWSE_HOST) {
            this.type = LogType.BROWSE_HOST;
            this.message = "<html>Host browsed by <b>" + uploader.getHost() + "</b></html>";
        } else {
            this.type = LogType.UPLOAD;
            this.message = "<html>Internal Upload</html>";
        }
    }

    long getTime() {
        return this.time;
    }

    LogType getType() {
        return this.type;
    }

    String getMessage() {
        return this.message;
    }
}

