/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.UIManager;

public class MediaPlayerPanel
extends BoxPanel
implements ThemeObserver,
ComponentListener {
    public MediaPlayerPanel(int n) {
        super(n);
        this.setOpaque(false);
        ThemeMediator.addThemeObserver(this);
        this.addComponentListener(this);
        this.updateTheme();
    }

    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getVisibleRect();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 18, 18);
        graphics2D.setColor(this.getBackground().darker().darker());
        graphics2D.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, 3 * rectangle.height / 4, 18, 18);
        graphics2D.setColor(this.getBackground().darker());
        graphics2D.drawRoundRect(rectangle.x, rectangle.y + 1, rectangle.width - 1, 3 * rectangle.height / 4, 18, 18);
        graphics2D.setColor(this.getBackground().brighter().brighter());
        graphics2D.drawRoundRect(rectangle.x, rectangle.y + rectangle.height / 4 - 0, rectangle.width - 1, 3 * rectangle.height / 4, 18, 18);
        graphics2D.setColor(this.getBackground().brighter());
        graphics2D.drawRoundRect(rectangle.x, rectangle.y + rectangle.height / 4 - 1, rectangle.width - 1, 3 * rectangle.height / 4, 18, 18);
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRoundRect(rectangle.x + 1, rectangle.y + 2, rectangle.width - 2, rectangle.height - 4, 18, 18);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public void updateTheme() {
        this.setBackground(UIManager.getColor("TableHeader.background"));
        this.repaint();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

