/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayListItem
implements Comparable<PlayListItem> {
    public static final String ALBUM = "Album";
    public static final String ARTIST = "Artist";
    public static final String BITRATE = "BitRate";
    public static final String COMMENT = "Comment";
    public static final String GENRE = "Genre";
    public static final String LENGTH = "Length";
    public static final String TIME = "Time";
    public static final String SIZE = "Size";
    public static final String TITLE = "Title";
    public static final String TRACK = "Track";
    public static final String TYPE = "Type";
    public static final String YEAR = "Year";
    public static final String VBR = "VBR";
    private final URI uri;
    private final AudioSource audioSource;
    private final String name;
    private final boolean isLocal;
    private final boolean isStorePreview;
    private final Map<String, String> properties;
    private String[] toolTips;

    public PlayListItem(File file) {
        this(file.toURI(), new AudioSource(file), file.getName(), true);
    }

    public PlayListItem(URI uRI, AudioSource audioSource, String string, boolean bl) {
        this(uRI, audioSource, string, bl, false);
    }

    public PlayListItem(URI uRI, AudioSource audioSource, String string, boolean bl, boolean bl2) {
        this(uRI, audioSource, string, bl, bl2, null);
    }

    public PlayListItem(URI uRI, AudioSource audioSource, String string, boolean bl, boolean bl2, Map<String, String> map) {
        if (uRI == null || string == null) {
            throw new IllegalArgumentException();
        }
        this.uri = uRI;
        this.audioSource = audioSource;
        this.name = string;
        this.isLocal = bl;
        this.isStorePreview = bl2;
        this.properties = map == null ? new HashMap<String, String>() : map;
        this.initMetaData();
    }

    private void initMetaData() {
        if (this.isLocal) {
            try {
                File file = new File(this.uri);
                MetaReader metaReader = GuiCoreMediator.getMetaDataFactory().parse(file);
                if (metaReader == null) {
                    return;
                }
                AudioMetaData audioMetaData = (AudioMetaData)metaReader.getMetaData();
                if (audioMetaData == null) {
                    return;
                }
                if (!this.properties.containsKey(ARTIST)) {
                    this.properties.put(ARTIST, audioMetaData.getArtist());
                }
                if (!this.properties.containsKey(ALBUM)) {
                    this.properties.put(ALBUM, audioMetaData.getAlbum());
                }
                if (!this.properties.containsKey(BITRATE)) {
                    this.properties.put(BITRATE, Integer.toString(audioMetaData.getBitrate()));
                }
                if (!this.properties.containsKey(COMMENT)) {
                    this.properties.put(COMMENT, audioMetaData.getComment());
                }
                if (!this.properties.containsKey(GENRE) && audioMetaData.getGenre() != null && audioMetaData.getGenre().length() > 0) {
                    this.properties.put(GENRE, audioMetaData.getGenre());
                }
                if (!this.properties.containsKey(LENGTH)) {
                    this.properties.put(LENGTH, Integer.toString(audioMetaData.getLength()));
                }
                if (!this.properties.containsKey(SIZE)) {
                    this.properties.put(SIZE, Long.toString(file.length()));
                }
                if (!this.properties.containsKey(TITLE)) {
                    this.properties.put(TITLE, audioMetaData.getTitle());
                }
                if (!this.properties.containsKey(TRACK) && audioMetaData.getTrack() != null) {
                    this.properties.put(TRACK, audioMetaData.getTrack());
                }
                if (!this.properties.containsKey(TYPE)) {
                    this.properties.put(TYPE, file.getName().substring(file.getName().length() - 3));
                }
                if (!this.properties.containsKey(YEAR) && audioMetaData.getYear() != null && audioMetaData.getYear().length() > 0) {
                    this.properties.put(YEAR, audioMetaData.getYear());
                }
                if (!this.properties.containsKey(TIME) && this.properties.containsKey(LENGTH)) {
                    this.properties.put(TIME, CommonUtils.seconds2time(audioMetaData.getLength()));
                } else {
                    this.properties.put(TIME, "-1");
                }
                if (!this.properties.containsKey(VBR)) {
                    this.properties.put(VBR, Boolean.toString(audioMetaData.isVBR()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public AudioSource getAudioSource() {
        return this.audioSource;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public String getProperty(String string, String string2) {
        String string3 = this.properties.get(string);
        return string3 != null ? string3 : string2;
    }

    public boolean isFile() {
        return this.isLocal;
    }

    public boolean isStorePreview() {
        return false;
    }

    public String[] getToolTips() {
        if (this.toolTips == null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(this.getName());
            if (this.properties.get(TITLE) != null) {
                linkedList.add(I18n.tr(TITLE) + ": " + this.properties.get(TITLE));
            }
            if (this.properties.get(ARTIST) != null) {
                linkedList.add(I18n.tr(ARTIST) + ": " + this.properties.get(ARTIST));
            }
            if (this.properties.get(ALBUM) != null) {
                linkedList.add(I18n.tr(ALBUM) + ": " + this.properties.get(ALBUM));
            }
            if (this.properties.get(GENRE) != null) {
                linkedList.add(I18n.tr(GENRE) + ": " + this.properties.get(GENRE));
            }
            if (this.properties.get(TRACK) != null) {
                linkedList.add(I18n.tr(TRACK) + ": " + this.properties.get(TRACK));
            }
            if (this.properties.get(YEAR) != null) {
                linkedList.add(I18n.tr(YEAR) + ": " + this.properties.get(YEAR));
            }
            if (this.properties.get(TIME) != null) {
                linkedList.add(I18n.tr(LENGTH) + ": " + this.properties.get(TIME));
            }
            if (this.properties.get(BITRATE) != null) {
                linkedList.add(I18n.tr("Bitrate") + ": " + this.properties.get(BITRATE) + " kbps" + (this.properties.get(VBR).equals("true") ? " (VBR)" : ""));
            }
            this.toolTips = linkedList.toArray(new String[linkedList.size()]);
        }
        return this.toolTips;
    }

    @Override
    public int compareTo(PlayListItem playListItem) {
        return playListItem.getURI().compareTo(this.uri);
    }
}

