/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public abstract class AbstractDirPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = I18nMarker.marktr("Folder:");
    protected final JTextField saveField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
    protected String saveDirectory;

    public AbstractDirPaneItem(String string) {
        this(string, I18n.tr("You can choose the folder for saving files."));
    }

    public AbstractDirPaneItem(String string, String string2) {
        super(string, string2);
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this.saveField);
        ButtonRow buttonRow = new ButtonRow(this.getActions(), 0, 12);
        this.add(labeledComponent.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(buttonRow);
        this.add(this.getVerticalSeparator());
    }

    private Action[] getActions() {
        return new Action[]{new SelectSaveDirectoryListener(), new DefaultListener()};
    }

    public abstract void initOptions();

    public abstract String getDefaultPath();

    public void setDirectoryPath(String string) {
        this.saveDirectory = string;
        this.saveField.setText(this.saveDirectory);
    }

    public abstract boolean applyOptions() throws IOException;

    public abstract boolean isDirty();

    private class SelectSaveDirectoryListener
    extends AbstractAction {
        public SelectSaveDirectoryListener() {
            this.putValue("Name", I18n.tr("Browse..."));
            this.putValue("ShortDescription", I18n.tr("Choose Another Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileChooserHandler.getInputDirectory(OptionsMediator.instance().getMainOptionsComponent(), new File(AbstractDirPaneItem.this.saveDirectory));
            if (file == null) {
                return;
            }
            if (!SaveDirectoryHandler.isSaveDirectoryValid(file)) {
                GUIMediator.showError(I18n.tr("The selected save folder is invalid. You may not have permissions to write to the selected folder. FrostWire will revert to your previously selected folder."));
                return;
            }
            if (!SaveDirectoryHandler.showVistaWarningIfNeeded(file)) {
                return;
            }
            try {
                String string = file.getCanonicalPath();
                if (!string.equals(AbstractDirPaneItem.this.saveDirectory)) {
                    AbstractDirPaneItem.this.saveField.setText(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class DefaultListener
    extends AbstractAction {
        public DefaultListener() {
            this.putValue("Name", I18n.tr("Use Default"));
            this.putValue("ShortDescription", I18n.tr("Use the Default Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractDirPaneItem.this.saveField.setText(AbstractDirPaneItem.this.getDefaultPath());
        }
    }
}

