/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class AutoClearUploadsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Clear Uploads");
    public static final String LABEL = I18n.tr("You can choose whether or not to automatically clear uploads that have completed.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Automatically Clear Completed Uploads:");
    private final JCheckBox CHECK_BOX = new JCheckBox();
    private boolean _clearUploads;

    public AutoClearUploadsPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this._clearUploads = SharingSettings.CLEAR_UPLOAD.getValue();
        this.CHECK_BOX.setSelected(this._clearUploads);
    }

    public boolean applyOptions() {
        boolean bl = this.CHECK_BOX.isSelected();
        if (bl != this._clearUploads) {
            SharingSettings.CLEAR_UPLOAD.setValue(bl);
            this._clearUploads = bl;
        }
        return false;
    }

    public boolean isDirty() {
        return SharingSettings.CLEAR_UPLOAD.getValue() != this.CHECK_BOX.isSelected();
    }
}

