/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import org.limewire.i18n.I18nMarker;

public final class PortPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Listening Port");
    public static final String LABEL = I18n.tr("You can set the local network port that listens for incoming connections. This port can be freely changed in case of conflict with another service on your system, or if a specific port number is required by the configuration of your firewall to direct incoming connections to your host.");
    private final String OPTION_LABEL = I18nMarker.marktr("Listen on Port:");
    private WholeNumberField _portField = new SizedWholeNumberField(0, 5, GUIUtils.SizePolicy.RESTRICT_BOTH);
    private int _port;
    private final NetworkManager networkManager;

    public PortPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this._portField, 120, 10);
        this.add(labeledComponent.getComponent());
        this.networkManager = GuiCoreMediator.getNetworkManager();
    }

    public void initOptions() {
        this._port = ConnectionSettings.PORT.getValue();
        this._portField.setValue(this._port);
    }

    public boolean applyOptions() throws IOException {
        int n = this._portField.getValue();
        if (n == this._port) {
            return false;
        }
        try {
            ConnectionSettings.PORT.setValue(n);
            this.networkManager.setListeningPort(n);
            this._port = n;
            this.networkManager.addressChanged();
        }
        catch (IOException iOException) {
            GUIMediator.showError(I18n.tr("Port not available. Please select a different port."));
            ConnectionSettings.PORT.setValue(this._port);
            this._portField.setValue(this._port);
            throw new IOException("port not available");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUIMediator.showError(I18n.tr("Please enter a port between 1 and 65535."));
            this._portField.setValue(this._port);
            throw new IOException("invalid port");
        }
        return false;
    }

    public boolean isDirty() {
        return ConnectionSettings.PORT.getValue() != this._portField.getValue();
    }
}

