/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.sharing;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.library.SharingUtils;
import java.io.File;

public class ShareManager {
    public static boolean checkAndWarnNewSharedFolder(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isDirectory() || !file.canRead()) {
            GUIMediator.showError(I18n.tr("<html><table width=400>You selected: <i>{0}</i><br>FrostWire cannot share this folder because it is either not a folder or cannot be read.<br><br>Please select another folder to share.</table></html>", file));
            return false;
        }
        if (!GuiCoreMediator.getFileManager().isFolderShareable(file, false)) {
            GUIMediator.showError(I18n.tr("<html><table width=400>You selected: <i>{0}</i><br>FrostWire cannot share this folder for security reasons.<br><br>Please select another folder to share.</table></html>", file));
            return false;
        }
        return !SharingUtils.isSensitiveDirectory(file) || ShareManager.warnAboutSensitiveDirectory(file);
    }

    public static boolean warnAboutSensitiveDirectory(File file) {
        String string = GUIUtils.convertToNonBreakingSpaces(0, file.getAbsolutePath());
        DialogOption dialogOption = GUIMediator.showYesNoMessage(I18n.tr("<html><table width=400>The folder <i>{0}</i><br>is likely to contain sensitive or personal information.<br><br>FrostWire recommends that you <b>DO NOT</b> share this folder.<br><br>Are you sure you want to share it?</table></html>", string), DialogOption.NO);
        if (dialogOption == DialogOption.YES) {
            GuiCoreMediator.getFileManager().validateSensitiveFile(file);
            return true;
        }
        GuiCoreMediator.getFileManager().invalidateSensitiveFile(file);
        return false;
    }
}

