/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.tables.ComponentMediator;
import com.limegroup.gnutella.gui.tabs.AbstractTab;
import com.limegroup.gnutella.gui.util.DividerLocationSettingUpdater;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;

public final class MonitorUploadTab
extends AbstractTab {
    private final JSplitPane SPLIT_PANE;
    private final MouseAdapter TESTING_MENU_LISTENER = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new ShowTestFTAction());
                jCheckBoxMenuItem.setState(true);
                jPopupMenu.add(jCheckBoxMenuItem);
                jPopupMenu.addSeparator();
                jPopupMenu.pack();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };

    public MonitorUploadTab(MonitorView monitorView, ComponentMediator componentMediator) {
        super(I18n.tr("Monitor"), I18n.tr("View Searches and Uploads"), "monitor_tab");
        this.SPLIT_PANE = new JSplitPane(0, monitorView, componentMediator.getComponent());
        this.SPLIT_PANE.setContinuousLayout(true);
        this.SPLIT_PANE.setOneTouchExpandable(true);
        DividerLocationSettingUpdater.install(this.SPLIT_PANE, UISettings.UI_MONITOR_UPLOAD_TAB_DIVIDER_LOCATION);
    }

    public void storeState(boolean bl) {
        ApplicationSettings.MONITOR_VIEW_ENABLED.setValue(bl);
    }

    public JComponent getComponent() {
        return this.SPLIT_PANE;
    }

    private class ShowTestFTAction
    extends AbstractAction {
        public ShowTestFTAction() {
            this.putValue("Name", I18n.tr("Test action!"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.print("test action!!");
        }
    }
}

