/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.util.Expand;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.limewire.setting.FileSetting;
import org.limewire.setting.IntSetting;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThemeSettings
extends LimeProps {
    private static final Log LOG;
    public static final String EXTENSION = "fwtp";
    public static final File THEME_DIR_FILE;
    public static final String FROSTWIRE_THEME_NAME = "frostwirePro_theme.fwtp";
    public static final String PINSTRIPES_OSX_THEME_NAME = "pinstripes_theme_osx.fwtp";
    public static final String BRUSHED_METAL_OSX_THEME_NAME = "brushed_metal_theme_osx.fwtp";
    public static final String WINDOWS_LAF_THEME_NAME = "windows_theme.fwtp";
    public static final String GTK_LAF_THEME_NAME = "GTK_theme.fwtp";
    public static final String PRO_THEME_NAME = "frostwirePro_theme.fwtp";
    public static final String OTHER_THEME_NAME = "other_theme.fwtp";
    public static final File FROSTWIRE_THEME_FILE;
    static final File PINSTRIPES_OSX_THEME_FILE;
    static final File BRUSHED_METAL_OSX_THEME_FILE;
    static final File WINDOWS_LAF_THEME_FILE;
    static final File GTK_LAF_THEME_FILE;
    static final File PRO_THEME_FILE;
    static final File OTHER_THEME_FILE;
    public static final File THEME_DEFAULT;
    public static final File THEME_DEFAULT_DIR;
    public static final FileSetting THEME_FILE;
    public static final FileSetting THEME_DIR;
    public static final List<String> JAR_THEME_NAMES;
    public static final IntSetting FONT_SIZE_INCREMENT;

    private ThemeSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> scanJarFileForThemes(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            long l = file.lastModified();
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (!string.endsWith(".fwtp")) continue;
                arrayList.add(string);
                File file2 = new File(THEME_DIR_FILE, string);
                File file3 = ThemeSettings.extractThemeDir(file2);
                if (!file2.isFile() && !file3.isDirectory() || l <= file2.lastModified() && l <= file3.lastModified()) continue;
                ThemeSettings.deleteZipWithOldTimestamp(file2);
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static File getThemesJarFromFrostWireThemePath() {
        String string;
        URL uRL = ThemeSettings.class.getClassLoader().getResource("frostwirePro_theme.fwtp");
        if (uRL != null && (string = uRL.toExternalForm()) != null && string.startsWith("jar:file:")) {
            string = string.substring("jar:file:".length(), string.length());
            string = string.substring(0, string.length() - "frostwirePro_theme.fwtp".length() - "!/".length());
            return new File(string);
        }
        return null;
    }

    private static File getThemesJar() {
        File file = new File(System.getProperty("user.dir") + File.separatorChar + "themes.jar");
        if (file != null && file.exists() && file.isFile()) {
            return file;
        }
        return ThemeSettings.getThemesJarFromFrostWireThemePath();
    }

    private static void deleteZipWithOldTimestamp(File file) {
        File file2 = ThemeSettings.extractThemeDir(file);
        if (file2.exists()) {
            String[] stringArray = file2.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    new File(file2, stringArray[i]).delete();
                }
            }
            file2.delete();
        }
        file.delete();
    }

    static boolean expandTheme(File file, File file2, boolean bl, boolean bl2) {
        file2.mkdirs();
        try {
            FileUtils.setWriteable(file2);
            Expand.expandFile(file, file2, bl);
        }
        catch (ZipException zipException) {
            GUIMediator.showError(I18n.tr("The theme you are applying is invalid. FrostWire will revert to the default theme."));
            return false;
        }
        catch (IOException iOException) {
            if (bl2) {
                ErrorService.error(iOException);
            }
            return false;
        }
        return true;
    }

    static File extractThemeDir(File file) {
        String string = file.getName();
        string = string.substring(0, string.length() - 5);
        return new File(new File(CommonUtils.getUserSettingsDir(), "themes"), string);
    }

    static boolean isThemeFile(File file) {
        return file.getName().toLowerCase().endsWith(".fwtp");
    }

    public static boolean isDefaultTheme() {
        return THEME_FILE.getValue().equals(THEME_DEFAULT);
    }

    public static boolean isGTKTheme() {
        return THEME_FILE.getValue().equals(GTK_LAF_THEME_FILE);
    }

    public static boolean isWindowsTheme() {
        return THEME_FILE.getValue().equals(WINDOWS_LAF_THEME_FILE);
    }

    public static boolean isBrushedMetalTheme() {
        return THEME_FILE.getValue().equals(BRUSHED_METAL_OSX_THEME_FILE);
    }

    public static boolean isPinstripesTheme() {
        return THEME_FILE.getValue().equals(PINSTRIPES_OSX_THEME_FILE);
    }

    public static boolean isNativeOSXTheme() {
        return OSUtils.isMacOSX() && (ThemeSettings.isPinstripesTheme() || ThemeSettings.isBrushedMetalTheme());
    }

    public static boolean isNativeTheme() {
        return ThemeSettings.isNativeOSXTheme() || ThemeSettings.isWindowsTheme() || ThemeSettings.isGTKTheme();
    }

    public static boolean isOtherTheme() {
        return THEME_FILE.getValue().equals(OTHER_THEME_FILE);
    }

    public static boolean isValid() {
        if (ThemeSettings.isOtherTheme()) {
            String string = ThemeSettings.getOtherLF();
            if (string != null) {
                try {
                    Class.forName(string);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOtherLF() {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(THEME_DIR_FILE, "other_theme/name.txt"))));
            String string = bufferedReader.readLine();
            if (string != null) {
                String string2 = string.trim();
                return string2;
            }
        }
        catch (IOException iOException) {
            LOG.warn("Ignoring IOX", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOtherLF(String string) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(THEME_DIR_FILE, "other_theme/name.txt"), false));
            bufferedWriter.write(string);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            LOG.warn("Ignoring IOX", iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String formatName(String string) {
        string = string.substring(0, string.length() - 5);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = string2.toLowerCase();
            if (string3.equals("osx")) {
                string2 = "(OSX)";
            } else if (string3.equals("limewire")) {
                string2 = "LimeWire";
            } else if (string3.equals("frostwirepro")) {
                string2 = "FrostWire";
            }
            stringBuilder.append(" " + string2.substring(0, 1).toUpperCase(Locale.US));
            if (string2.length() <= 1) continue;
            stringBuilder.append(string2.substring(1));
        }
        return stringBuilder.toString().trim();
    }

    public static boolean recoverFromJar() {
        GUIMediator.showMessage("FTA: FrostWire will look for skin's jar file. Using system directory it would be: " + System.getProperty("user.dir"));
        File file = new File(CommonUtils.getCurrentDirectory() + System.getProperty("file.separator") + "themes.jar");
        if (!file.exists()) {
            GUIMediator.showError(I18n.tr("The file containing default themes for FrostWire cannot be found.\nYou will need to download the files manually."));
            return false;
        }
        List<String> list = ThemeSettings.scanJarFileForThemes(file);
        File file2 = THEME_DIR_FILE;
        try {
            FileUtils.setWriteable(file2);
            Expand.expandFile(file, file2, false);
        }
        catch (ZipException zipException) {
            GUIMediator.showError(I18n.tr("The theme you are applying is invalid. FrostWire will revert to the default theme."));
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static {
        File file;
        LOG = LogFactory.getLog(ThemeSettings.class);
        THEME_DIR_FILE = new File(CommonUtils.getUserSettingsDir(), "themes");
        FROSTWIRE_THEME_FILE = new File(THEME_DIR_FILE, "frostwirePro_theme.fwtp");
        PINSTRIPES_OSX_THEME_FILE = new File(THEME_DIR_FILE, PINSTRIPES_OSX_THEME_NAME);
        BRUSHED_METAL_OSX_THEME_FILE = new File(THEME_DIR_FILE, BRUSHED_METAL_OSX_THEME_NAME);
        WINDOWS_LAF_THEME_FILE = new File(THEME_DIR_FILE, WINDOWS_LAF_THEME_NAME);
        GTK_LAF_THEME_FILE = new File(THEME_DIR_FILE, GTK_LAF_THEME_NAME);
        PRO_THEME_FILE = new File(THEME_DIR_FILE, "frostwirePro_theme.fwtp");
        OTHER_THEME_FILE = new File(THEME_DIR_FILE, OTHER_THEME_NAME);
        File file2 = ThemeSettings.getThemesJar();
        JAR_THEME_NAMES = file2 == null || !file2.isFile() ? Collections.emptyList() : ThemeSettings.scanJarFileForThemes(file2);
        if (OSUtils.isMacOSX()) {
            file2 = PINSTRIPES_OSX_THEME_FILE;
            file = new File(THEME_DIR_FILE, "pinstripes_theme_osx");
        } else if (LimeWireUtils.isPro()) {
            file2 = PRO_THEME_FILE;
            file = new File(THEME_DIR_FILE, "frostwirePro_theme");
        } else if (OSUtils.isNativeThemeWindows()) {
            file2 = WINDOWS_LAF_THEME_FILE;
            file = new File(THEME_DIR_FILE, "windows_theme");
        } else if (OSUtils.isLinux()) {
            file2 = GTK_LAF_THEME_FILE;
            file = new File(THEME_DIR_FILE, "GTK_theme");
        } else {
            file2 = FROSTWIRE_THEME_FILE;
            file = new File(THEME_DIR_FILE, "frostwirePro_theme");
        }
        THEME_DEFAULT = file2;
        THEME_DEFAULT_DIR = file;
        THEME_FILE = FACTORY.createFileSetting("THEME_FILE", THEME_DEFAULT);
        THEME_DIR = FACTORY.createFileSetting("THEME_DIR", THEME_DEFAULT_DIR);
        FONT_SIZE_INCREMENT = FACTORY.createIntSetting("FONT_SIZE_INCREMENT", 0);
    }
}

