/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.trees;

import com.limegroup.gnutella.gui.trees.AbstractTreeModel;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;

public class FileTreeModel
extends AbstractTreeModel {
    private List<File> subRoots;
    private Hashtable<String, List<File>> subChildren = new Hashtable();
    private File cachedDir;
    private boolean cacheSorted;
    private File[] cache;
    private Comparator<File> comparator = DEFAULT_COMPARATOR;
    private FileFilter filter = new DefaultFilter();
    private boolean sort = true;
    public static final Comparator<File> DEFAULT_COMPARATOR = new FileComparator();

    public FileTreeModel(String string, File ... fileArray) {
        super(string);
        if (fileArray != null) {
            this.subRoots = new ArrayList<File>(fileArray.length);
            for (int i = 0; i < fileArray.length; ++i) {
                this.addSubRoot(fileArray[i]);
            }
        } else {
            this.subRoots = new ArrayList<File>();
        }
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public int getChildCount(Object object) {
        if (object instanceof File && ((File)object).canRead()) {
            return this.getSubDirs((File)object, false).length;
        }
        if (this.root.getClass().isInstance(object)) {
            if (object.equals(this.root)) {
                return this.subRoots.size();
            }
            return this.subChildren.get(object).size();
        }
        return 0;
    }

    public Object getChild(Object object, int n) {
        if (object instanceof File) {
            File[] fileArray = this.getSubDirs((File)object, this.sort);
            if (n >= fileArray.length) {
                return null;
            }
            return fileArray[n];
        }
        if (this.root.getClass().isInstance(object)) {
            if (object.equals(this.root) && n < this.subRoots.size()) {
                return this.subRoots.get(n);
            }
            List<File> list = this.subChildren.get(object);
            return n < list.size() ? list.get(n) : null;
        }
        return null;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof File) {
            File[] fileArray = this.getSubDirs((File)object, this.sort);
            if (fileArray == null) {
                return -1;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] != object2) continue;
                return i;
            }
        } else if (this.root.getClass().isInstance(object)) {
            if (object.equals(this.root)) {
                return this.subRoots.indexOf(object2);
            }
            return this.subChildren.get(object).indexOf(object2);
        }
        return -1;
    }

    private File[] getSubDirs(File file, boolean bl) {
        if (file == this.cachedDir && this.cacheSorted == bl) {
            return this.cache;
        }
        File[] fileArray = file.listFiles(this.filter);
        if (fileArray == null) {
            this.cache = new File[0];
        } else {
            this.cache = fileArray;
            if (bl) {
                Arrays.sort(this.cache, this.comparator);
            }
        }
        this.cachedDir = file;
        this.cacheSorted = bl;
        return this.cache;
    }

    public void addSubRoot(File file) {
        if (this.subRoots.contains(file)) {
            return;
        }
        this.subRoots.add(file);
        Object[] objectArray = new Object[]{this.root};
        int[] nArray = new int[]{this.subRoots.size() - 1};
        Object[] objectArray2 = new Object[]{file};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, objectArray, nArray, objectArray2));
    }

    public boolean isSubRoot(File file) {
        return this.subRoots.contains(file);
    }

    public void removeSubRoot(File file) {
        int n = this.subRoots.indexOf(file);
        if (n != -1) {
            this.subRoots.remove(n);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, new Object[]{this.root}, new int[]{n}, new Object[]{file}));
        }
    }

    public void removeSubRoots() {
        for (int i = 0; i < this.subRoots.size(); ++i) {
            this.subChildren.remove(this.subRoots.get(i));
        }
        this.subRoots.clear();
        Object[] objectArray = new Object[]{this.root};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, objectArray));
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, treePath));
    }

    public void removeChildrenOfSubRoot(String string) {
        if (!this.subRoots.contains(string)) {
            return;
        }
        this.subChildren.get(string).clear();
        Object[] objectArray = new Object[]{this.root, string};
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, objectArray));
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.filter = fileFilter;
    }

    public FileFilter getFileFilter() {
        return this.filter;
    }

    public void setSortListedFiles(boolean bl) {
        if (this.sort != bl) {
            this.sort = bl;
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
        }
    }

    public boolean getSortListedFiles() {
        return this.sort;
    }

    private class DefaultFilter
    implements FileFilter {
        private DefaultFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() && !file.isHidden();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            return file.getAbsolutePath().compareToIgnoreCase(file2.getAbsolutePath());
        }
    }
}

