/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml;

import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.IndentingPanel;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.limewire.collection.NameValue;
import org.limewire.util.I18NConvert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputPanel
extends IndentingPanel {
    private final LimeXMLSchema SCHEMA;

    public InputPanel(LimeXMLSchema limeXMLSchema, ActionListener actionListener, Document document, UndoManager undoManager) {
        this(limeXMLSchema, actionListener, document, undoManager, false, false, true);
    }

    public InputPanel(LimeXMLSchema limeXMLSchema, ActionListener actionListener, Document document, UndoManager undoManager, boolean bl, boolean bl2, boolean bl3) {
        super(limeXMLSchema, actionListener, document, undoManager, bl, bl2, bl3);
        this.SCHEMA = limeXMLSchema;
    }

    public String getSchemaURI() {
        return this.SCHEMA.getSchemaURI();
    }

    public String getInput() {
        return this.getInput(false);
    }

    public String getInput(boolean bl) {
        LinkedList<NameValue<String>> linkedList = new LinkedList<NameValue<String>>();
        for (SchemaFieldInfo object2 : this.SCHEMA.getCanonicalizedFields()) {
            JComponent jComponent;
            String string = object2.getCanonicalizedFieldName();
            JComponent jComponent2 = this.getField(string);
            String string2 = "";
            if (jComponent2 instanceof JTextField) {
                jComponent = (JTextField)jComponent2;
                string2 = ((JTextComponent)jComponent).getText();
            } else if (jComponent2 instanceof JComboBox) {
                jComponent = (JComboBox)jComponent2;
                string2 = ((ComboBoxValue)((JComboBox)jComponent).getSelectedItem()).getValue();
            }
            if (string2 == null || string2.equals("")) continue;
            if (bl) {
                string2 = I18NConvert.instance().getNorm(string2);
            }
            linkedList.add(new NameValue<String>(string, string2));
        }
        String string = this.SCHEMA.getSchemaURI();
        String string3 = this.constructXML(linkedList, string);
        return string3;
    }

    public void storeInput() {
        List<SchemaFieldInfo> list = this.SCHEMA.getCanonicalizedFields();
        for (int i = 0; i < list.size(); ++i) {
            AutoCompleteTextField autoCompleteTextField;
            SchemaFieldInfo schemaFieldInfo = list.get(i);
            String string = schemaFieldInfo.getCanonicalizedFieldName();
            JComponent jComponent = this.getField(string);
            if (!(jComponent instanceof AutoCompleteTextField) || (autoCompleteTextField = (AutoCompleteTextField)jComponent).getText().equals("")) continue;
            autoCompleteTextField.addToDictionary();
        }
    }

    private String getCompositeQuery() {
        List<SchemaFieldInfo> list = this.SCHEMA.getCanonicalizedFields();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            JComponent jComponent;
            SchemaFieldInfo schemaFieldInfo = list.get(i);
            String string = schemaFieldInfo.getCanonicalizedFieldName();
            JComponent jComponent2 = this.getField(string);
            String string2 = "";
            if (jComponent2 instanceof JTextField) {
                jComponent = (JTextField)jComponent2;
                string2 = ((JTextComponent)jComponent).getText();
            } else if (jComponent2 instanceof JComboBox) {
                jComponent = (JComboBox)jComponent2;
                string2 = ((ComboBoxValue)((JComboBox)jComponent).getSelectedItem()).toString();
            }
            if (string2 == null || string2.trim().length() <= 1) continue;
            stringBuilder.append(string2 + " ");
        }
        return stringBuilder.toString().trim();
    }

    public String getStandardQuery() {
        return QueryUtils.createQueryString(this.getCompositeQuery(), true);
    }

    public String getTitleForQuery() {
        return this.getCompositeQuery();
    }

    public String constructXML(List<NameValue<String>> list, String string) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(list, string).getXMLString();
    }
}

