/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.http.WriteHeadersIOState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Properties;

public abstract class WriteHandshakeState
extends WriteHeadersIOState {
    protected final HandshakeSupport support;

    protected WriteHandshakeState(HandshakeSupport handshakeSupport) {
        super(null);
        this.support = handshakeSupport;
    }

    static class WriteRequestState
    extends WriteHandshakeState {
        private Properties request;

        WriteRequestState(HandshakeSupport handshakeSupport, Properties properties) {
            super(handshakeSupport);
            this.request = properties;
        }

        protected ByteBuffer createOutgoingData() {
            StringBuilder stringBuilder = new StringBuilder();
            this.support.appendConnectLine(stringBuilder);
            this.support.appendHeaders(this.request, stringBuilder);
            return ByteBuffer.wrap(stringBuilder.toString().getBytes());
        }

        protected void processWrittenHeaders() {
        }
    }

    static class WriteResponseState
    extends WriteHandshakeState {
        private HandshakeResponder responder;
        private HandshakeResponse response;
        private boolean outgoing;

        WriteResponseState(HandshakeSupport handshakeSupport, HandshakeResponder handshakeResponder, boolean bl) {
            super(handshakeSupport);
            this.responder = handshakeResponder;
            this.outgoing = bl;
        }

        protected ByteBuffer createOutgoingData() throws IOException {
            HandshakeResponse handshakeResponse = this.outgoing ? this.support.getReadHandshakeRemoteResponse() : this.support.getReadHandshakeResponse();
            this.response = this.responder.respond(handshakeResponse, this.outgoing);
            StringBuilder stringBuilder = new StringBuilder();
            this.support.appendResponse(this.response, stringBuilder);
            return ByteBuffer.wrap(stringBuilder.toString().getBytes());
        }

        protected void processWrittenHeaders() throws IOException {
            block10: {
                block9: {
                    if (!this.outgoing) break block9;
                    switch (this.response.getStatusCode()) {
                        case 200: {
                            break block10;
                        }
                        case 503: {
                            throw NoGnutellaOkException.CLIENT_REJECT;
                        }
                        case 577: {
                            throw NoGnutellaOkException.CLIENT_REJECT_LOCALE;
                        }
                        default: {
                            throw NoGnutellaOkException.createClientUnknown(this.response.getStatusCode());
                        }
                    }
                }
                switch (this.response.getStatusCode()) {
                    case 200: 
                    case 593: {
                        break;
                    }
                    case 503: {
                        throw NoGnutellaOkException.CLIENT_REJECT;
                    }
                    default: {
                        throw NoGnutellaOkException.createClientUnknown(this.response.getStatusCode());
                    }
                }
            }
        }
    }
}

