/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LicenseType {
    NO_LICENSE(""),
    CC_LICENSE("creativecommons.org/licenses/"),
    WEED_LICENSE("http://www.shmedlic.com/license/3play.aspx"),
    DRM_LICENSE(""),
    GPL("http://www.gnu.org/copyleft/gpl.html"),
    LGPL("http://www.gnu.org/copyleft/lgpl.html"),
    APACHE_BSD("http://opensource.org/licenses/apache2.0.php"),
    MIT_X("http://opensource.org/licenses/mit-license.php"),
    FDL("http://www.gnu.org/copyleft/fdl.html"),
    ARTISTIC("http://www.opensource.org/licenses/artistic-license.php"),
    PUBLIC_DOMAIN("http://www.public-domain.org"),
    SHAREWARE("http://en.wikipedia.org/wiki/Shareware"),
    LIMEWIRE_STORE_PURCHASE("LIMEWIRE_STORE_PURCHASE");

    private final String keyword;
    private final List<String> indivList;

    private LicenseType(String string2) {
        this.keyword = string2;
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string2);
        this.indivList = Collections.unmodifiableList(arrayList);
    }

    public boolean isDRMLicense() {
        return this == WEED_LICENSE || this == DRM_LICENSE || this == LIMEWIRE_STORE_PURCHASE;
    }

    public List<String> getIndivisibleKeywords() {
        return this.indivList;
    }

    public static LicenseType determineLicenseType(String string, String string2) {
        if (LicenseType.hasCCLicense(string, string2)) {
            return CC_LICENSE;
        }
        if (LicenseType.hasWeedLicense(string2)) {
            return WEED_LICENSE;
        }
        if (LicenseType.hasDRMLicense(string2)) {
            return DRM_LICENSE;
        }
        if (LicenseType.hasLWSLicense(string2)) {
            return LIMEWIRE_STORE_PURCHASE;
        }
        for (LicenseType licenseType : LicenseType.values()) {
            if (!licenseType.keyword.equals(string2)) continue;
            return licenseType;
        }
        return NO_LICENSE;
    }

    private static boolean hasCCLicense(String string, String string2) {
        if (string != null) {
            string = string.toLowerCase(Locale.US);
        }
        return string2 != null && string2.equals("creativecommons.org/licenses/") || string != null && string.indexOf("creativecommons.org/licenses/") != -1 && string.indexOf("verify at") != -1;
    }

    private static boolean hasWeedLicense(String string) {
        return string != null && string.startsWith("http://www.shmedlic.com/license/3play.aspx") && string.indexOf(" vid: ") != -1 && string.indexOf(" cid: ") != -1;
    }

    private static boolean hasDRMLicense(String string) {
        return string != null && string.startsWith("licensed: ");
    }

    private static boolean hasLWSLicense(String string) {
        return string != null && string.startsWith("NOT CLEARED");
    }
}

