/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.limewire.io.IOUtils;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.routing.Contact;
import org.limewire.security.MACCalculatorRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTContactsMessage
extends AbstractVendorMessage {
    public static final int VERSION = 1;
    private final Collection<? extends Contact> nodes;

    public DHTContactsMessage(Contact contact) {
        this(Collections.singleton(contact));
    }

    public DHTContactsMessage(Collection<? extends Contact> collection) {
        super(F_LIME_VENDOR_ID, 33, 1, DHTContactsMessage.derivePayload(collection));
        this.nodes = collection;
    }

    public DHTContactsMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 33, n, byArray2, network);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        MessageInputStream messageInputStream = new MessageInputStream(byteArrayInputStream, mACCalculatorRepositoryManager);
        try {
            this.nodes = messageInputStream.readContacts();
        }
        catch (IOException iOException) {
            throw new BadPacketException(iOException);
        }
        finally {
            IOUtils.close(messageInputStream);
        }
    }

    public Collection<? extends Contact> getContacts() {
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] derivePayload(Collection<? extends Contact> collection) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessageOutputStream messageOutputStream = new MessageOutputStream(byteArrayOutputStream);
        try {
            messageOutputStream.writeContacts(collection);
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.close(messageOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

