/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.RoutableGGEPMessage;
import java.net.UnknownHostException;
import org.limewire.io.IPPortCombo;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionRequestImpl
extends RoutableGGEPMessage
implements InspectionRequest {
    static final String INSPECTION_KEY = "I";
    static final String TIMESTAMP_KEY = "T";
    static final String ENCODING_KEY = "E";
    private static final int DEFAULT_INTERVAL = 500;
    private final String[] requested;
    private final boolean timestamp;
    private final boolean encoding;
    private final int sendInterval;

    public InspectionRequestImpl(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 30, n, byArray2, network);
        String string;
        try {
            string = this.ggep.getString(INSPECTION_KEY);
            this.timestamp = this.ggep.hasKey(TIMESTAMP_KEY);
            this.encoding = this.ggep.hasKey(ENCODING_KEY);
            int n2 = 500;
            try {
                n2 = this.ggep.getInt(ENCODING_KEY);
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
            this.sendInterval = n2;
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new BadPacketException();
        }
        this.requested = string.split(";");
    }

    InspectionRequestImpl(RoutableGGEPMessage.GGEPSigner gGEPSigner, String ... stringArray) {
        this(new GUID(), gGEPSigner, false, false, 500, 1L, null, null, stringArray);
    }

    public InspectionRequestImpl(GUID gUID, RoutableGGEPMessage.GGEPSigner gGEPSigner, boolean bl, boolean bl2, int n, long l, IpPort ipPort, IpPort ipPort2, String ... stringArray) {
        super(F_LIME_VENDOR_ID, 30, 1, gGEPSigner, InspectionRequestImpl.deriveGGEP(bl, bl2, n, l, ipPort, ipPort2, stringArray));
        this.setGUID(gUID);
        this.requested = stringArray;
        this.timestamp = bl;
        this.encoding = bl2;
        this.sendInterval = n;
    }

    @Override
    public String[] getRequestedFields() {
        return this.requested;
    }

    @Override
    public boolean requestsTimeStamp() {
        return this.timestamp;
    }

    @Override
    public boolean supportsEncoding() {
        return this.encoding;
    }

    @Override
    public void setGUID(GUID gUID) {
        super.setGUID(gUID);
    }

    private static GGEP deriveGGEP(boolean bl, boolean bl2, int n, long l, IpPort ipPort, IpPort ipPort2, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(";");
        }
        String string = stringBuilder.charAt(stringBuilder.length() - 1) == ';' ? stringBuilder.substring(0, stringBuilder.length() - 1) : stringBuilder.toString();
        GGEP gGEP = new GGEP();
        gGEP.putCompressed(INSPECTION_KEY, string.getBytes());
        if (bl) {
            gGEP.put(TIMESTAMP_KEY);
        }
        if (bl2) {
            gGEP.put(ENCODING_KEY, n);
        }
        if (ipPort != null) {
            try {
                IPPortCombo iPPortCombo = new IPPortCombo(ipPort.getAddress(), ipPort.getPort());
                gGEP.put("RA", iPPortCombo.toBytes());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (ipPort2 != null) {
            try {
                IPPortCombo iPPortCombo = new IPPortCombo(ipPort2.getAddress(), ipPort2.getPort());
                gGEP.put("TO", iPPortCombo.toBytes());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (l >= 0L) {
            gGEP.put("V", l);
        }
        return gGEP;
    }

    @Override
    public int getVersion() {
        return super.getVersion();
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return InspectionRequest.class;
    }

    @Override
    public int getSendInterval() {
        return this.sendInterval;
    }
}

