/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.util.ByteOrder;

public final class ReplyNumberVendorMessage
extends AbstractVendorMessage {
    public static final int OLD_VERSION = 2;
    public static final int VERSION = 3;
    protected static final byte UNSOLICITED = 1;

    ReplyNumberVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 12, n, byArray2, network);
        if (n < 2) {
            throw new BadPacketException("ancient version");
        }
        if (n < 3) {
            if (SearchSettings.DISABLE_OOB_V2.getBoolean()) {
                throw new BadPacketException("OOB v2 not allowed");
            }
            if (this.getPayload().length != 2) {
                throw new BadPacketException("v2 message too large");
            }
        }
        if (this.getPayload().length < 2) {
            throw new BadPacketException("VERSION " + n + " UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
    }

    ReplyNumberVendorMessage(GUID gUID, int n, int n2, boolean bl) {
        super(F_LIME_VENDOR_ID, 12, n, ReplyNumberVendorMessage.derivePayload(n2, bl));
        this.setGUID(gUID);
    }

    private static byte[] derivePayload(int n, boolean bl) {
        if (n < 1 || n > 255) {
            throw new IllegalArgumentException("Number of results too big: " + n);
        }
        byte[] byArray = new byte[2];
        ByteOrder.short2leb((short)n, byArray, 0);
        byArray[1] = bl ? (byte)1 : 0;
        return byArray;
    }

    public int getNumResults() {
        return ByteOrder.ubyte2int(this.getPayload()[0]);
    }

    public boolean canReceiveUnsolicited() {
        if (this.getVersion() == 1) {
            return true;
        }
        return (this.getPayload()[1] & 1) == 1;
    }

    public boolean equals(Object object) {
        if (object instanceof ReplyNumberVendorMessage) {
            GUID gUID = new GUID(this.getGUID());
            GUID gUID2 = new GUID(((VendorMessage)object).getGUID());
            int n = ((ReplyNumberVendorMessage)object).getNumResults();
            return gUID.equals(gUID2) && this.getNumResults() == n && super.equals(object);
        }
        return false;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
    }

    public boolean isOOBv3() {
        return this.getVersion() == 3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(", num results: ").append(this.getNumResults());
        stringBuilder.append(", canReceiveUnsolicited:").append(this.canReceiveUnsolicited());
        return stringBuilder.toString();
    }
}

