/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaWriter;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;

public class MetaDataWriter {
    private final String fileName;
    private final MetaWriter editor;
    protected LimeXMLDocument correctDocument = null;

    public MetaDataWriter(String string, MetaDataFactory metaDataFactory) {
        this.fileName = string;
        this.editor = metaDataFactory.getEditorForFile(string);
    }

    public boolean needsToUpdate(MetaData metaData) {
        if (this.editor.getMetaData() == null) {
            return false;
        }
        if (metaData == null) {
            return true;
        }
        return !this.editor.getMetaData().equals(metaData);
    }

    public LimeXMLReplyCollection.MetaDataState commitMetaData() {
        return this.editor.commitMetaData(this.fileName);
    }

    public void populate(LimeXMLDocument limeXMLDocument) {
        if (this.editor == null) {
            throw new NullPointerException("Editor not created");
        }
        this.correctDocument = limeXMLDocument;
        this.editor.populate(limeXMLDocument);
    }

    public LimeXMLDocument getCorrectDocument() {
        return this.correctDocument;
    }

    public MetaWriter getEditor() {
        return this.editor;
    }
}

