/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioDataReader
implements MetaReader {
    public static final String ISO_LATIN_1 = "8859_1";
    public static final String UNICODE = "Unicode";
    public static final String MAGIC_KEY = "NOT CLEARED";
    protected final AudioMetaData audioData = new AudioMetaData();

    public AudioDataReader(File file) throws IOException, IllegalArgumentException {
        this.parseFile(file);
    }

    private void readHeader(AudioHeader audioHeader) {
        this.audioData.setVBR(audioHeader.isVariableBitRate());
        this.audioData.setSampleRate(audioHeader.getSampleRateAsNumber());
        this.audioData.setBitrate((int)audioHeader.getBitRateAsNumber());
        this.audioData.setLength(audioHeader.getTrackLength());
    }

    protected void readTag(AudioFile audioFile, Tag tag) {
        this.audioData.setTitle(tag.getFirstTitle());
        this.audioData.setArtist(tag.getFirstArtist());
        this.audioData.setAlbum(tag.getFirstAlbum());
        this.audioData.setYear(tag.getFirstYear());
        this.audioData.setComment(tag.getFirstComment());
        this.audioData.setTrack(tag.getFirstTrack());
        this.audioData.setGenre(tag.getFirstGenre());
    }

    private void parseFile(File file) throws IOException, IllegalArgumentException {
        try {
            AudioFile audioFile = AudioFileIO.read(file);
            this.readHeader(audioFile.getAudioHeader());
            this.readTag(audioFile, audioFile.getTag());
        }
        catch (CannotReadException cannotReadException) {
            throw (IOException)new IOException().initCause(cannotReadException);
        }
        catch (TagException tagException) {
            throw (IOException)new IOException().initCause(tagException);
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            throw (IOException)new IOException().initCause(readOnlyFileException);
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            throw (IOException)new IOException().initCause(invalidAudioFrameException);
        }
    }

    @Override
    public MetaData getMetaData() {
        return this.audioData;
    }

    @Override
    public String getSchemaURI() {
        return "http://www.limewire.com/schemas/audio.xsd";
    }

    @Override
    public List<NameValue<String>> toNameValueList() {
        return this.audioData.toNameValueList();
    }
}

