/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.video.reader.VideoDataReader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;

public class MPEGMetaData
extends VideoDataReader {
    private static final Log LOG = LogFactory.getLog(MPEGMetaData.class);
    private static final int PACK_START_CODE = 442;
    private static final int SEQ_START_CODE = 435;
    private static final int MAX_FORWARD_READ_LENGTH = 50000;
    private static final int MAX_BACKWARD_READ_LENGTH = 3000000;

    public MPEGMetaData(File file) throws IOException {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            this.parseMPEG(randomAccessFile);
        }
        catch (Throwable throwable) {
            IOUtils.close(randomAccessFile);
            throw throwable;
        }
        IOUtils.close(randomAccessFile);
    }

    private void parseMPEG(RandomAccessFile randomAccessFile) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = -1L;
        do {
            byte[] byArray;
            LOG.debug("Advancing to next code...");
            this.nextStartCode(randomAccessFile);
            int n = randomAccessFile.readInt();
            if (n == 442 && !bl) {
                LOG.debug("Found GOP code");
                bl = true;
                byArray = new byte[6];
                randomAccessFile.readFully(byArray);
                if ((byArray[0] & 0xF0) == 32) {
                    l = this.getMPEGHMS(byArray);
                    continue;
                }
                if ((byArray[0] & 0xC0) != 64) continue;
                l = this.getMPEG2HMS(byArray);
                continue;
            }
            if (n != 435 || bl2) continue;
            LOG.debug("Found SEQ code");
            bl2 = true;
            byArray = new byte[3];
            randomAccessFile.readFully(byArray);
            this.videoData.setWidth((byArray[0] & 0xFF) << 4 | byArray[1] & 0xF0);
            this.videoData.setHeight((byArray[1] & 0xF) << 8 | byArray[2] & 0xFF);
        } while (!bl2 || !bl);
        if (l != -1L) {
            randomAccessFile.seek(randomAccessFile.length());
            while (true) {
                LOG.debug("Rewinding to prior code...");
                this.previousStartCode(randomAccessFile);
                if (randomAccessFile.readInt() == 442) break;
                randomAccessFile.seek(randomAccessFile.getFilePointer() - 4L);
            }
            LOG.debug("Found GOP code");
            bl3 = true;
            if (bl3) {
                byte[] byArray = new byte[6];
                long l2 = -1L;
                randomAccessFile.readFully(byArray);
                if ((byArray[0] & 0xF0) == 32) {
                    l2 = this.getMPEGHMS(byArray);
                } else if ((byArray[0] & 0xC0) == 64) {
                    l2 = this.getMPEG2HMS(byArray);
                }
                if (l2 != -1L) {
                    this.videoData.setLength((int)(l2 - l));
                }
            }
        }
    }

    private void nextStartCode(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        for (int i = 0; i < 50000; i += n) {
            n = randomAccessFile.read(byArray);
            if (n > 0) {
                i += n;
                for (int j = 0; j < n - 2; ++j) {
                    if (byArray[j] != 0 || byArray[j + 1] != 0 || byArray[j + 2] != 1) continue;
                    randomAccessFile.seek(randomAccessFile.getFilePointer() - (long)(n - j));
                    return;
                }
                continue;
            }
            throw new IOException("no start code");
        }
        throw new IOException("no start code");
    }

    private void previousStartCode(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[8024];
        for (int i = 0; i < 3000000; i += byArray.length) {
            long l = randomAccessFile.getFilePointer() - (long)byArray.length;
            if (l < 0L) {
                if (l <= (long)byArray.length) break;
                l = 0L;
            }
            randomAccessFile.seek(l);
            randomAccessFile.readFully(byArray);
            for (int j = byArray.length - 1; j > 1; --j) {
                if (byArray[j - 2] != 0 || byArray[j - 1] != 0 || byArray[j] != 1) continue;
                randomAccessFile.seek(randomAccessFile.getFilePointer() - (long)(byArray.length - j) - 2L);
                return;
            }
            randomAccessFile.seek(randomAccessFile.getFilePointer() - (long)byArray.length);
        }
        throw new IOException("no prior start code");
    }

    protected long getMPEGHMS(byte[] byArray) {
        long l = ((byArray[0] & 0xFF) >> 1 & 3) << 30 | (byArray[1] & 0xFF) << 22 | (byArray[2] & 0xFF) >> 1 << 15 | (byArray[3] & 0xFF) << 7 | (byArray[4] & 0xFF) >> 1;
        return l / 90000L;
    }

    protected long getMPEG2HMS(byte[] byArray) {
        long l = (byArray[0] & 0x18) >> 3 << 30 | (byArray[0] & 3) << 28 | (byArray[1] & 0xFF) << 20 | (byArray[2] & 0xF8) >> 1 << 15 | (byArray[2] & 3) << 13 | (byArray[3] & 0xFF) << 5 | (byArray[4] & 0xFF) >> 3;
        int n = (byArray[4] & 3) << 7 | (byArray[5] & 0xFF) >> 1;
        if (n == 0) {
            return l / 90000L;
        }
        return -1L;
    }
}

