/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.security.MerkleTree;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashTreeUtils {
    private static final Log LOG = LogFactory.getLog(HashTreeUtils.class);
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final int BLOCK_SIZE = 1024;
    public static final byte INTERNAL_HASH_PREFIX = 1;

    public static List<List<byte[]>> createAllParentNodes(List<byte[]> list, MessageDigest messageDigest) {
        ArrayList<List<byte[]>> arrayList = new ArrayList<List<byte[]>>();
        arrayList.add(Collections.unmodifiableList(list));
        while (list.size() > 1) {
            list = HashTreeUtils.createParentGeneration(list, messageDigest);
            arrayList.add(0, list);
        }
        return arrayList;
    }

    public static List<byte[]> createParentGeneration(List<byte[]> list, MessageDigest messageDigest) {
        messageDigest.reset();
        int n = list.size();
        n = n % 2 == 0 ? n / 2 : (n + 1) / 2;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n);
        Iterator<byte[]> iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = iterator.next();
            if (iterator.hasNext()) {
                byte[] byArray2 = iterator.next();
                messageDigest.reset();
                messageDigest.update((byte)1);
                messageDigest.update(byArray, 0, byArray.length);
                messageDigest.update(byArray2, 0, byArray2.length);
                byte[] byArray3 = messageDigest.digest();
                arrayList.add(byArray3);
                continue;
            }
            arrayList.add(byArray);
        }
        return arrayList;
    }

    public static List<byte[]> createTreeNodes(int n, long l, InputStream inputStream, MessageDigest messageDigest) throws IOException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>((int)Math.ceil((double)l / (double)n));
        MerkleTree merkleTree = new MerkleTree(messageDigest);
        byte[] byArray = new byte[131072];
        long l2 = 0L;
        int n2 = 0;
        while (l2 < l) {
            int n3 = 0;
            long l3 = System.currentTimeMillis();
            merkleTree.reset();
            while (n3 < n && (n2 = inputStream.read(byArray)) != -1) {
                merkleTree.update(byArray, 0, n2);
                n3 += n2;
                l2 += (long)n2;
                try {
                    long l4 = (System.currentTimeMillis() - l3) * 2L;
                    if (l4 > 0L) {
                        Thread.sleep(l4);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("interrupted during hashing operation");
                }
                l3 = System.currentTimeMillis();
            }
            arrayList.add(merkleTree.digest());
            if (l2 == l) {
                if (n2 == -1 || inputStream.read() == -1) continue;
                LOG.warn("More data than fileSize!");
                throw new IOException("unknown file size.");
            }
            if (n2 != -1 || l2 == l) continue;
            if (LOG.isWarnEnabled()) {
                LOG.warn("couldn't hash whole file. read: " + n2 + ", offset: " + l2 + ", fileSize: " + l);
            }
            throw new IOException("couldn't hash whole file.");
        }
        return arrayList;
    }

    public static int calculateDepth(long l) {
        if (l < 262144L) {
            return 0;
        }
        if (l < 524288L) {
            return 1;
        }
        if (l < 0x100000L) {
            return 2;
        }
        if (l < 0x200000L) {
            return 3;
        }
        if (l < 0x400000L) {
            return 4;
        }
        if (l < 0x800000L) {
            return 5;
        }
        if (l < 0x1000000L) {
            return 6;
        }
        if (l < 0x2000000L) {
            return 7;
        }
        if (l < 0x4000000L) {
            return 8;
        }
        if (l < 0x10000000L) {
            return 9;
        }
        if (l < 0x40000000L) {
            return 10;
        }
        if (l < 0x100000000L) {
            return 11;
        }
        if (l < 0x1000000000L) {
            return 12;
        }
        return 13;
    }

    public static int calculateNodeSize(long l, int n) {
        long l2 = 1 << n;
        long l3 = l / l2;
        if (l % l2 != 0L) {
            ++l3;
        }
        int n2 = MerkleTree.log2Ceil(l3);
        int n3 = 1 << n2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("fileSize " + l);
            LOG.debug("depth " + n);
            LOG.debug("nodeSize " + n3);
        }
        assert ((long)n3 * l2 >= l) : "nodeSize: " + n3 + ", fileSize: " + l + ", maxNode: " + l2;
        assert ((long)n3 * l2 <= l * 2L) : "nodeSize: " + n3 + ", fileSize: " + l + ", maxNode: " + l2;
        return n3;
    }
}

