/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree.dime;

import com.limegroup.gnutella.dime.AsyncDimeParser;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeFactory;
import com.limegroup.gnutella.tigertree.ThexReader;
import com.limegroup.gnutella.tigertree.dime.TigerDimeReadUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.limewire.nio.statemachine.ReadState;

class AsyncTigerTreeReader
extends ReadState
implements ThexReader {
    private final String sha1;
    private final long fileSize;
    private final String root32;
    private final AsyncDimeParser parser;
    private final HashTreeFactory tigerTreeFactory;

    public AsyncTigerTreeReader(String string, long l, String string2, HashTreeFactory hashTreeFactory) {
        this.sha1 = string;
        this.fileSize = l;
        this.root32 = string2;
        this.parser = new AsyncDimeParser();
        this.tigerTreeFactory = hashTreeFactory;
    }

    protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        return this.parser.process(readableByteChannel, byteBuffer);
    }

    public HashTree getHashTree() throws IOException {
        List<DIMERecord> list = this.parser.getRecords();
        return this.tigerTreeFactory.createHashTree(TigerDimeReadUtils.nodesFromRecords(list.iterator(), this.fileSize, this.root32), this.sha1, this.fileSize);
    }

    public long getAmountProcessed() {
        return this.parser.getAmountProcessed();
    }
}

