/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree.dime;

import com.limegroup.gnutella.dime.DIMEParser;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.tigertree.HashTreeUtils;
import com.limegroup.gnutella.tigertree.dime.TigerDimeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Base32;
import org.limewire.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TigerDimeReadUtils {
    private static final Log LOG = LogFactory.getLog(TigerDimeReadUtils.class);

    public static List<List<byte[]>> read(InputStream inputStream, long l, String string) throws IOException {
        LOG.trace("creating HashTreeHandler from network");
        DIMEParser dIMEParser = new DIMEParser(inputStream);
        return TigerDimeReadUtils.nodesFromRecords(dIMEParser, l, string);
    }

    static List<List<byte[]>> nodesFromRecords(Iterator<DIMERecord> iterator, long l, String string) throws IOException {
        if (!iterator.hasNext()) {
            throw new IOException("no xml record");
        }
        DIMERecord dIMERecord = iterator.next();
        if (!iterator.hasNext()) {
            throw new IOException("no tree record");
        }
        DIMERecord dIMERecord2 = iterator.next();
        if (LOG.isDebugEnabled()) {
            LOG.debug("xml id: [" + dIMERecord.getIdentifier() + "]");
            LOG.debug("xml type: [" + dIMERecord.getTypeString() + "]");
            LOG.debug("tree id: [" + dIMERecord2.getIdentifier() + "]");
            LOG.debug("tree type: [" + dIMERecord2.getTypeString() + "]");
            LOG.debug("xml type num: [" + dIMERecord.getTypeId() + "]");
            LOG.debug("tree type num: [" + dIMERecord2.getTypeId() + "]");
        }
        while (iterator.hasNext()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("more elements in the dime record.");
            }
            iterator.next();
        }
        String string2 = new String(dIMERecord.getData(), "UTF-8");
        byte[] byArray = dIMERecord2.getData();
        XMLTreeDescription xMLTreeDescription = new XMLTreeDescription(string2);
        if (!xMLTreeDescription.isValid()) {
            throw new IOException("invalid XMLTreeDescription " + xMLTreeDescription.toString());
        }
        if (xMLTreeDescription.getFileSize() != l) {
            throw new IOException("file size attribute was " + xMLTreeDescription.getFileSize() + " expected " + l);
        }
        HashTreeDescription hashTreeDescription = new HashTreeDescription(byArray);
        if (!Base32.encode(hashTreeDescription.getRoot()).equals(string)) {
            throw new IOException("Root hashes do not match");
        }
        return hashTreeDescription.getAllNodes(l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashTreeDescription {
        private final byte[] DATA;

        protected HashTreeDescription(byte[] byArray) {
            this.DATA = byArray;
        }

        byte[] getRoot() throws IOException {
            if (this.DATA.length < TigerDimeUtils.HASH_SIZE) {
                throw new IOException("invalid data");
            }
            byte[] byArray = new byte[TigerDimeUtils.HASH_SIZE];
            System.arraycopy(this.DATA, 0, byArray, 0, TigerDimeUtils.HASH_SIZE);
            return byArray;
        }

        List<List<byte[]>> getAllNodes(long l) throws IOException {
            Object object;
            int n = HashTreeUtils.calculateDepth(l);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            byte[] byArray = this.DATA;
            if (byArray.length % TigerDimeUtils.HASH_SIZE != 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("illegal size of data field for HashTree");
                }
                throw new IOException("corrupted hash tree detected");
            }
            int n2 = 0;
            while (n2 + TigerDimeUtils.HASH_SIZE <= byArray.length) {
                object = new byte[TigerDimeUtils.HASH_SIZE];
                System.arraycopy(byArray, n2, object, 0, TigerDimeUtils.HASH_SIZE);
                arrayList.add(object);
                n2 += TigerDimeUtils.HASH_SIZE;
            }
            Iterator iterator = arrayList.iterator();
            object = new ArrayList(1);
            Object object2 = null;
            int n3 = 0;
            boolean bl = false;
            ArrayList<List<byte[]>> arrayList2 = new ArrayList<List<byte[]>>(n + 1);
            while (n3 <= n && iterator.hasNext()) {
                Object object3;
                bl = false;
                byte[] byArray2 = (byte[])iterator.next();
                object.add(byArray2);
                if (object2 == null) {
                    bl = true;
                    ++n3;
                    object2 = object;
                    arrayList2.add((List<byte[]>)object);
                    object = new ArrayList(2);
                    continue;
                }
                if (object.size() > object2.size() * 2) {
                    if (LOG.isDebugEnabled()) {
                        byte[] byArray3;
                        Object object4;
                        LOG.debug("parent");
                        object3 = "";
                        Object object5 = object2.iterator();
                        while (object5.hasNext()) {
                            object4 = (byte[])object5.next();
                            object3 = (String)object3 + Base32.encode((byte[])object4) + "; ";
                        }
                        LOG.debug(object3);
                        object3 = "";
                        LOG.debug("newparent");
                        object5 = HashTreeUtils.createParentGeneration((List<byte[]>)object, new Tiger());
                        object4 = object5.iterator();
                        while (object4.hasNext()) {
                            byArray3 = (byte[])object4.next();
                            object3 = (String)object3 + Base32.encode(byArray3) + "; ";
                        }
                        LOG.debug(object3);
                        object3 = "";
                        LOG.debug("generation");
                        object4 = object.iterator();
                        while (object4.hasNext()) {
                            byArray3 = (byte[])object4.next();
                            object3 = (String)object3 + Base32.encode(byArray3) + "; ";
                        }
                        LOG.debug(object3);
                        object3 = "";
                    }
                    throw new IOException("corrupted hash tree detected");
                }
                if (object.size() != object2.size() * 2 - 1 && object.size() != object2.size() * 2 || !this.isMatching((List<byte[]>)object2, (List<byte[]>)(object3 = HashTreeUtils.createParentGeneration((List<byte[]>)object, new Tiger())))) continue;
                object2 = object;
                arrayList2.add(Collections.unmodifiableList(object));
                if (++n3 <= n && iterator.hasNext()) {
                    object = new ArrayList(object2.size() * 2);
                }
                bl = true;
            }
            if (!bl) {
                throw new IOException("corrupted hash tree detected");
            }
            LOG.debug("Valid hash tree received.");
            return arrayList2;
        }

        private boolean isMatching(List<byte[]> list, List<byte[]> list2) {
            if (list.size() == list2.size()) {
                for (int i = 0; i < list.size(); ++i) {
                    byte[] byArray;
                    byte[] byArray2 = list.get(i);
                    if (Arrays.equals(byArray2, byArray = list2.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static final class Resolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2.equals("http://open-content.net/spec/thex/thex.dtd")) {
                InputSource inputSource = new InputSource(new StringReader("<!ELEMENT hashtree (file,digest,serializedtree)><!ELEMENT file EMPTY><!ATTLIST file size CDATA #REQUIRED><!ATTLIST file segmentsize CDATA #REQUIRED><!ELEMENT digest EMPTY><!ATTLIST digest algorithm CDATA #REQUIRED><!ATTLIST digest outputsize CDATA #REQUIRED><!ELEMENT serializedtree EMPTY><!ATTLIST serializedtree depth CDATA #REQUIRED><!ATTLIST serializedtree type CDATA #REQUIRED><!ATTLIST serializedtree uri CDATA #REQUIRED>"));
                inputSource.setPublicId("-//NET//OPEN-CONTENT//THEX 02//EN");
                inputSource.setSystemId("http://open-content.net/spec/thex/thex.dtd");
                return inputSource;
            }
            if (string == null) {
                throw new SAXException("Can't resolve SYSTEM entity at '" + string2 + "'");
            }
            throw new SAXException("Can't resolve PUBLIC entity '" + string + "' at '" + string2 + "'");
        }
    }

    private static class XMLTreeDescription {
        private static final int UNKNOWN = 0;
        private static final int VALID = 1;
        private static final int INVALID = 2;
        private int _parsed = 0;
        private long _fileSize = 0L;
        private int _blockSize = 0;
        private String _algorithm = null;
        private int _hashSize = 0;
        private String _serializationType = null;
        private String _uri;
        private String data;

        protected XMLTreeDescription(String string) {
            this.data = string;
        }

        long getFileSize() {
            return this._fileSize;
        }

        String getURI() {
            return this._uri;
        }

        boolean isValid() {
            if (this._parsed == 0) {
                int n = this._parsed = this.parse() ? 1 : 2;
            }
            if (this._parsed == 2) {
                return false;
            }
            if (this._blockSize != 1024) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected block size: " + this._blockSize);
                }
                return false;
            }
            if (!"http://open-content.net/spec/digest/tiger".equals(this._algorithm)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unsupported digest algorithm: " + this._algorithm);
                }
                return false;
            }
            if (this._hashSize != TigerDimeUtils.HASH_SIZE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected block size: " + this._blockSize);
                }
                return false;
            }
            if (!"http://open-content.net/spec/thex/breadthfirst".equals(this._serializationType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unexpected serialization type: " + this._serializationType);
                }
                return false;
            }
            return true;
        }

        private boolean parse() {
            int n = this.data.indexOf("system");
            if (n > 0 && n < this.data.indexOf("http://open-content.net/spec/thex/thex.dtd")) {
                this.data = this.data.substring(0, n) + "SYSTEM" + this.data.substring(n + "system".length());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XMLTreeDescription read: " + this.data);
            }
            Document document = null;
            try {
                document = XMLUtils.getDocument(this.data, new Resolver(), new XMLUtils.LogErrorHandler(LOG));
            }
            catch (IOException iOException) {
                LOG.debug(iOException);
                return false;
            }
            Node node = document.getElementsByTagName("hashtree").item(0);
            if (node == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("couldn't find hashtree element: " + this.data);
                }
                return false;
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                Element element = (Element)node2;
                if (element.getTagName().equals("file")) {
                    this.parseFileElement(element);
                    continue;
                }
                if (element.getTagName().equals("digest")) {
                    this.parseDigestElement(element);
                    continue;
                }
                if (!element.getTagName().equals("serializedtree")) continue;
                this.parseSerializedtreeElement(element);
            }
            return true;
        }

        private void parseFileElement(Element element) {
            block5: {
                block4: {
                    try {
                        this._fileSize = Long.parseLong(element.getAttribute("size"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug("couldn't parse file size: " + element.getNodeValue(), numberFormatException);
                    }
                }
                try {
                    this._blockSize = Integer.parseInt(element.getAttribute("segmentsize"));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("couldn't parse block size: " + element.getNodeValue(), numberFormatException);
                }
            }
        }

        private void parseDigestElement(Element element) {
            block2: {
                this._algorithm = element.getAttribute("algorithm");
                try {
                    this._hashSize = Integer.parseInt(element.getAttribute("outputsize"));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("couldn't parse hash size: " + element.getNodeValue(), numberFormatException);
                }
            }
        }

        private void parseSerializedtreeElement(Element element) {
            block2: {
                this._serializationType = element.getAttribute("type");
                this._uri = element.getAttribute("uri");
                try {
                    Integer.parseInt(element.getAttribute("depth"));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("couldn't parse depth: " + element.getNodeValue(), numberFormatException);
                }
            }
        }
    }
}

