/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParsingUtils {
    private static final Log LOG = LogFactory.getLog(XMLParsingUtils.class);
    private static final String XML_START = "<?xml";
    private static ThreadLocal<LimeParser> _parserContainer = new ThreadLocal<LimeParser>(){

        @Override
        protected LimeParser initialValue() {
            return new LimeParser();
        }
    };

    public static ParseResult parse(String string, int n) throws IOException, SAXException {
        string = LimeXMLUtils.scanForBadCharacters(string);
        return XMLParsingUtils.parse(new InputSource(new StringReader(string)), n);
    }

    public static ParseResult parse(InputSource inputSource) throws IOException, SAXException {
        return XMLParsingUtils.parse(inputSource, 8);
    }

    public static ParseResult parse(InputSource inputSource, int n) throws IOException, SAXException {
        ParseResult parseResult = new ParseResult(n);
        LimeParser limeParser = _parserContainer.get();
        limeParser.parse(parseResult, inputSource);
        return parseResult;
    }

    public static List<String> split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(XML_START);
        int n2 = string.indexOf(XML_START, n + 1);
        while (n2 != -1) {
            arrayList.add(string.substring(n, n2));
            n = n2;
            n2 = string.indexOf(XML_START, n + 1);
        }
        if (n != -1) {
            arrayList.add(string.substring(n));
        }
        return arrayList;
    }

    private static class LimeParser
    extends DefaultHandler {
        private final XMLReader _reader;
        private ParseResult _result;
        boolean _isFirstElement = true;

        LimeParser() {
            XMLReader xMLReader;
            try {
                xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                xMLReader.setContentHandler(this);
                xMLReader.setErrorHandler(this);
                xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
            }
            catch (SAXException sAXException) {
                ErrorService.error(sAXException);
                xMLReader = null;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ErrorService.error(parserConfigurationException);
                xMLReader = null;
            }
            this._reader = xMLReader;
        }

        public void parse(ParseResult parseResult, InputSource inputSource) throws SAXException, IOException {
            if (this._reader == null) {
                return;
            }
            this._isFirstElement = true;
            this._result = parseResult;
            this._reader.parse(inputSource);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (this._isFirstElement) {
                this._isFirstElement = false;
                this._result.canonicalKeyPrefix = string3;
                return;
            }
            if (this._result.type == null) {
                this._result.type = string3;
                this._result.schemaURI = "http://www.limewire.com/schemas/" + this._result.type + ".xsd";
                this._result.canonicalKeyPrefix = this._result.canonicalKeyPrefix + "__" + string3 + "__";
            }
            int n = attributes.getLength();
            this._result.canonicalKeyPrefix = this._result.canonicalKeyPrefix.toLowerCase(Locale.US);
            if (n > 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>(n);
                for (int i = 0; i < n; ++i) {
                    String string4 = attributes.getQName(i).toLowerCase(Locale.US);
                    hashMap.put(this._result.canonicalKeyPrefix + string4 + "__", attributes.getValue(i).trim());
                }
                this._result.add(hashMap);
            } else {
                Map map = Collections.emptyMap();
                this._result.add(map);
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            LOG.fatal("Fatal parsing error", sAXParseException);
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            LOG.warn("parse warning", sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            LOG.error("Parsing error", sAXParseException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResult
    extends ArrayList<Map<String, String>> {
        public String schemaURI;
        public String type;
        public String canonicalKeyPrefix;

        public ParseResult(int n) {
            super(n * 2 / 3);
        }
    }
}

