/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.IRCServer;
import irc.Query;
import irc.QueryListener;
import irc.ReplyServerListener;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.NickMenuHandler;
import irc.gui.pixx.PixxConfiguration;
import irc.style.StyledList;
import java.awt.event.MouseEvent;
import java.util.Locale;

public class AWTQuery
extends BaseAWTSource
implements QueryListener,
ReplyServerListener {
    private NickMenuHandler _menu;

    public AWTQuery(PixxConfiguration pixxConfiguration, Query query) {
        super(pixxConfiguration, query);
        this._menu = new NickMenuHandler(pixxConfiguration, this, query);
        query.addQueryListener(this);
        query.getIRCServer().addReplyServerListener(this);
        this.update();
        this.print("  This is a private conversation with " + this._source.getName() + ".", 3);
        this.print("  We caution you against giving out any personally identifiable information (such as your social security number, credit card number, name, address, telephone number, driver's license number, password(s), etc.) online. This information can easily be used for illegal or harmful purposes.", 4);
        this.print("");
    }

    public void release() {
        ((Query)this._source).removeQueryListeners(this);
        ((Query)this._source).getIRCServer().removeReplyServerListener(this);
        this._menu.release();
        this._menu = null;
        super.release();
    }

    private void update() {
        String string = ((Query)this._source).getWhois();
        String[] stringArray = new String[]{this._source.getName() + ":" + this._pixxConfiguration.getIRCConfiguration().formatASL(string), this._source.getServer().getNick() + ":" + this._pixxConfiguration.getIRCConfiguration().formatASL(this._source.getServer().getUserName())};
        this._list.setNickList(stringArray);
        this.title();
    }

    private void title() {
        String string = ((Query)this._source).getWhois();
        if (string.length() > 0) {
            this.setTitle(this._source.getName() + " (" + this._pixxConfiguration.getIRCConfiguration().formatASL(string) + ")");
        } else {
            this.setTitle(" FrostWire Chat: Private conversation with " + this._source.getName() + ".");
        }
    }

    public void nickChanged(String string, Query query) {
        this.update();
    }

    public void whoisChanged(String string, Query query) {
        this.update();
    }

    private String whois(String string) {
        if ((string = string.toLowerCase(Locale.ENGLISH)).equals(this._source.getName().toLowerCase(Locale.ENGLISH))) {
            return ((Query)this._source).getWhois();
        }
        if (string.equals(this._source.getServer().getNick().toLowerCase(Locale.ENGLISH))) {
            return this._source.getServer().getUserName();
        }
        return "";
    }

    public void nickEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickpopup", mouseEvent)) {
            this._menu.popup(string, this.whois(string), this._list, mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.nickEvent(styledList, string, mouseEvent);
        }
    }

    public Boolean replyReceived(String string, String string2, String[] stringArray, IRCServer iRCServer) {
        if (string2.equals("301") && stringArray[1].toLowerCase(Locale.ENGLISH).equals(this._source.getName().toLowerCase(Locale.ENGLISH))) {
            String string3 = "\u000314      *** " + stringArray[1] + " is currently away.";
            for (int i = 2; i < stringArray.length; ++i) {
                string3 = string3 + " Away message: " + stringArray[i];
            }
            this._source.report(string3);
        }
        return Boolean.FALSE;
    }
}

