/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.ListenerGroup;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxNickListListener;
import irc.gui.pixx.PixxPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class PixxNickList
extends PixxPanel
implements MouseListener,
MouseMotionListener {
    private Vector _nicks;
    private Image _buffer;
    private Font _font;
    private int _base;
    private int _selected;
    private int _overindex;
    private int _overX;
    private int _toScroll;
    private Object _scrollLock = new Object();
    private ListenerGroup _listeners;
    private char[] _prefixes;
    private boolean _leftAlign;

    public PixxNickList(PixxConfiguration pixxConfiguration, char[] cArray) {
        super(pixxConfiguration);
        this._prefixes = cArray;
        this._toScroll = 0;
        this._selected = -1;
        this._overindex = -1;
        this._listeners = new ListenerGroup();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._base = 0;
        this._nicks = new Vector();
        this._font = new Font("", 0, 12);
        this._leftAlign = this._pixxConfiguration.getB("leftnickalign");
    }

    public void release() {
        this.dispose();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        super.release();
    }

    public void addPixxNickListListener(PixxNickListListener pixxNickListListener) {
        this._listeners.addListener(pixxNickListListener);
    }

    public void removePixxNickListListener(PixxNickListListener pixxNickListListener) {
        this._listeners.removeListener(pixxNickListListener);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._pixxConfiguration.getI("nicklistwidth"), 16);
    }

    public void dispose() {
        this.reinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() {
        Object object = this._scrollLock;
        synchronized (object) {
            this._toScroll = 0;
            this._buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scroll(int n) {
        Object object = this._scrollLock;
        synchronized (object) {
            this._toScroll += n;
            this._base += n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getScrollValue() {
        Object object = this._scrollLock;
        synchronized (object) {
            int n = this._toScroll;
            this._toScroll = 0;
            return n;
        }
    }

    public void setBase(int n) {
        this.scroll(n - this._base);
        this.repaint();
    }

    public int getBase() {
        return this._base;
    }

    public int getNickCount() {
        return this._nicks.size();
    }

    public void add(String string) {
        this._nicks.insertElementAt(string, this._nicks.size());
        this.reinit();
        this.repaint();
    }

    public void remove(String string) {
        for (int i = 0; i < this._nicks.size(); ++i) {
            String string2 = (String)this._nicks.elementAt(i);
            if (!string2.equals(string)) continue;
            this._nicks.removeElementAt(i);
            break;
        }
        this.reinit();
        this.repaint();
    }

    public void set(String[] stringArray) {
        this._nicks = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            this._nicks.insertElementAt(stringArray[i], this._nicks.size());
        }
        this.reinit();
        this.repaint();
    }

    public void removeAll() {
        this._nicks = new Vector();
        this.reinit();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    private Color findColor(String string) {
        return this._pixxConfiguration.getIRCConfiguration().getASLColor(string, this.getColor(13), this.getColor(14), this.getColor(15));
    }

    private void update(Graphics graphics, int n, int n2) {
        int n3 = this.getSize().width;
        int n4 = this._font.getSize();
        graphics.setColor(this.getColor(6));
        graphics.fillRect(0, n, n3, n2);
        graphics.setColor(this.getColor(0));
        graphics.drawLine(n3 - 1, n, n3 - 1, n + n2 - 1);
        graphics.setFont(this._font);
        int n5 = 8;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = this._base;
        while (n5 + n4 + 5 < n) {
            n5 += n4 + 6;
            ++n6;
        }
        if (n6 > 0) {
            n5 -= n4 + 6;
            --n6;
        }
        while (n6 < this._nicks.size() && n5 <= n + n2) {
            int n7;
            String string = (String)this._nicks.elementAt(n6);
            String string2 = "";
            int n8 = string.indexOf(":");
            Color color = this.getColor(5);
            if (n8 != -1) {
                string2 = string.substring(n8 + 1);
                string = string.substring(0, n8);
                color = this.findColor(string2);
            }
            if (this._selected == n6) {
                color = this.getColor(7);
            }
            char c = '\u0000';
            for (n7 = 0; n7 < this._prefixes.length; ++n7) {
                if (string.length() <= 0 || string.charAt(0) != this._prefixes[n7]) continue;
                c = this._prefixes[n7];
            }
            if (c > '\u0000') {
                string = string.substring(1);
            }
            n7 = fontMetrics.stringWidth(string);
            graphics.setColor(color);
            graphics.fillRect(20, n5 - 1, n3 - 28, n4 + 2);
            graphics.setColor(this.getColor(1));
            graphics.drawRect(20, n5 - 1, n3 - 28, n4 + 2);
            graphics.setColor(this.getColor(1));
            graphics.setClip(20, n5 - 1, n3 - 28, n4 + 2);
            int n9 = n3 - n7 - 12;
            if (n9 < 22) {
                n9 = 22;
            }
            if (this._leftAlign) {
                n9 = 22;
            }
            graphics.drawString(string, n9, n5 + n4 - 1);
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            if (c > '\u0000') {
                if (c == '@') {
                    graphics.setColor(this.getColor(11));
                } else if (c == '+') {
                    graphics.setColor(this.getColor(10));
                } else if (c == '%') {
                    graphics.setColor(this.getColor(12));
                } else {
                    graphics.setColor(this.getColor(5));
                }
                graphics.fillRect(20 - n4 - 6, n5 - 1, n4 + 2, n4 + 2);
                graphics.setColor(this.getColor(1));
                graphics.drawRect(20 - n4 - 6, n5 - 1, n4 + 2, n4 + 2);
                graphics.setColor(this.getColor(1));
                n7 = fontMetrics.stringWidth("" + c);
                int n10 = 20 - n4 - 6 + (n4 + 2 - n7) / 2 + 1;
                int n11 = n5 + n4 - 1;
                if (c == '@') {
                    --n10;
                    --n11;
                }
                graphics.drawString("" + c, n10, n11);
            }
            n5 += n4 + 6;
            ++n6;
        }
    }

    public void update(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = this._font.getSize();
        if (this._buffer != null && (this._buffer.getWidth(this) != n || this._buffer.getHeight(this) != n2)) {
            this._buffer = null;
        }
        if (this._buffer == null) {
            try {
                this._buffer = this.createImage(n, n2);
                Graphics graphics2 = this._buffer.getGraphics();
                this.update(graphics2, 0, n2);
            }
            catch (Throwable throwable) {
                return;
            }
        } else {
            int n4 = this.getScrollValue();
            if (n4 != 0) {
                Graphics graphics3 = this._buffer.getGraphics();
                int n5 = -(n3 + 6) * n4;
                if (n5 < 0) {
                    graphics3.copyArea(0, -n5, n, n2 + n5, 0, n5);
                    this.update(graphics3, n2 + n5, -n5);
                } else {
                    graphics3.copyArea(0, 0, n, n2 - n5, 0, n5);
                    this.update(graphics3, 0, n5);
                }
            }
        }
        if (this._buffer != null) {
            graphics.drawImage(this._buffer, 0, 0, this);
        }
        if (this._overindex != -1 && this._pixxConfiguration.getIRCConfiguration().getB("style:floatingasl")) {
            int n6 = this._overX;
            int n7 = 8 + (this._overindex - this._base) * (n3 + 6) + 2;
            if (n7 + n3 + 5 >= n2) {
                n7 = n2 - n3 - 5;
            }
            String string = this.getInfo(this._overindex);
            String string2 = this._pixxConfiguration.getIRCConfiguration().formatASL(string);
            if (string2.length() > 0) {
                int n8 = graphics.getFontMetrics().stringWidth(string2);
                if (n6 + n8 + 5 >= n) {
                    n6 = n - n8 - 5;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                graphics.setColor(this.getAlphaColor(this.findColor(string), this._pixxConfiguration.getIRCConfiguration().getI("style:floatingaslalpha")));
                graphics.fillRect(n6, n7, n8 + 4, n3 + 4);
                graphics.setColor(this.getColor(1));
                graphics.drawRect(n6, n7, n8 + 4, n3 + 4);
                graphics.drawString(string2, n6 + 2, n7 + n3);
            }
        }
    }

    private Color getAlphaColor(Color color, int n) {
        try {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        }
        catch (Throwable throwable) {
            return color;
        }
    }

    private int getIndex(int n, int n2) {
        int n3 = this._font.getSize();
        n2 += n3 + 6;
        n2 -= 8;
        n2 /= n3 + 6;
        --n2;
        if ((n2 += this._base) < 0) {
            n2 = -1;
        }
        if (n2 >= this._nicks.size()) {
            n2 = -1;
        }
        return n2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this._overindex != -1) {
            this._overindex = -1;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this._selected = n = this.getIndex(mouseEvent.getX(), mouseEvent.getY());
        this.reinit();
        this.repaint();
        if (this._selected != -1) {
            this._listeners.sendEventAsync("eventOccured", this.getNick(this._selected), mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    private String getUnprefixedNick(String string) {
        if (string.length() == 0) {
            return string;
        }
        for (int i = 0; i < this._prefixes.length; ++i) {
            if (string.charAt(0) != this._prefixes[i]) continue;
            return string.substring(1);
        }
        return string;
    }

    private String getNick(int n) {
        if (n == -1) {
            return "";
        }
        String string = (String)this._nicks.elementAt(n);
        int n2 = (string = this.getUnprefixedNick(string)).indexOf(":");
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    private String getInfo(int n) {
        if (n == -1) {
            return "";
        }
        String string = (String)this._nicks.elementAt(n);
        string = this.getUnprefixedNick(string);
        int n2 = string.indexOf(":");
        String string2 = "";
        if (n2 != -1) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this._pixxConfiguration.getIRCConfiguration().getASLMaster()) {
            return;
        }
        int n = this.getIndex(mouseEvent.getX(), mouseEvent.getY());
        if (n == this._overindex) {
            return;
        }
        this._overindex = n;
        this._overX = mouseEvent.getX();
        this.repaint();
        if (n != -1) {
            this._listeners.sendEventAsync("ASLEventOccured", this.getNick(n), this.getInfo(n));
        }
    }
}

