/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.AnonymousAndLocalClassExclusionStrategy;
import com.google.gson.DefaultTypeAdapters;
import com.google.gson.DisjunctionExclusionStrategy;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.JavaFieldNamingPolicy;
import com.google.gson.JsonCompactFormatter;
import com.google.gson.JsonDeserializationContextDefault;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonFormatter;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContextDefault;
import com.google.gson.JsonSerializer;
import com.google.gson.MappedObjectConstructor;
import com.google.gson.ModifierBasedExclusionStrategy;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.SerializedNameAnnotationInterceptingNamingPolicy;
import com.google.gson.SyntheticFieldExclusionStrategy;
import com.google.gson.VersionExclusionStrategy;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Gson {
    private static final String NULL_STRING = "null";
    static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    static final AnonymousAndLocalClassExclusionStrategy DEFAULT_ANON_LOCAL_CLASS_EXCLUSION_STRATEGY = new AnonymousAndLocalClassExclusionStrategy();
    static final SyntheticFieldExclusionStrategy DEFAULT_SYNTHETIC_FIELD_EXCLUSION_STRATEGY = new SyntheticFieldExclusionStrategy(true);
    static final ModifierBasedExclusionStrategy DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY = new ModifierBasedExclusionStrategy(128, 8);
    static final JsonFormatter DEFAULT_JSON_FORMATTER = new JsonCompactFormatter();
    static final FieldNamingStrategy DEFAULT_NAMING_POLICY = new SerializedNameAnnotationInterceptingNamingPolicy(new JavaFieldNamingPolicy());
    private static final ExclusionStrategy DEFAULT_EXCLUSION_STRATEGY = Gson.createExclusionStrategy(-1.0);
    private static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    private final ExclusionStrategy serializationStrategy;
    private final ExclusionStrategy deserializationStrategy;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final MappedObjectConstructor objectConstructor;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    private final JsonFormatter formatter;
    private final boolean serializeNulls;
    private final boolean generateNonExecutableJson;

    public Gson() {
        this(DEFAULT_EXCLUSION_STRATEGY, DEFAULT_EXCLUSION_STRATEGY, DEFAULT_NAMING_POLICY, new MappedObjectConstructor(DefaultTypeAdapters.getDefaultInstanceCreators()), DEFAULT_JSON_FORMATTER, false, DefaultTypeAdapters.getDefaultSerializers(), DefaultTypeAdapters.getDefaultDeserializers(), false);
    }

    Gson(ExclusionStrategy serializationStrategy, ExclusionStrategy deserializationStrategy, FieldNamingStrategy fieldNamingPolicy, MappedObjectConstructor objectConstructor, JsonFormatter formatter, boolean serializeNulls, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, boolean generateNonExecutableGson) {
        this.serializationStrategy = serializationStrategy;
        this.deserializationStrategy = deserializationStrategy;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.objectConstructor = objectConstructor;
        this.formatter = formatter;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
        this.deserializers = deserializers;
        this.generateNonExecutableJson = generateNonExecutableGson;
    }

    private ObjectNavigatorFactory createDefaultObjectNavigatorFactory(ExclusionStrategy strategy) {
        return new ObjectNavigatorFactory(strategy, this.fieldNamingPolicy);
    }

    private static ExclusionStrategy createExclusionStrategy(double version) {
        LinkedList<ExclusionStrategy> strategies = new LinkedList<ExclusionStrategy>();
        strategies.add(DEFAULT_ANON_LOCAL_CLASS_EXCLUSION_STRATEGY);
        strategies.add(DEFAULT_SYNTHETIC_FIELD_EXCLUSION_STRATEGY);
        strategies.add(DEFAULT_MODIFIER_BASED_EXCLUSION_STRATEGY);
        if (version != -1.0) {
            strategies.add(new VersionExclusionStrategy(version));
        }
        return new DisjunctionExclusionStrategy(strategies);
    }

    public JsonElement toJsonTree(Object src) {
        if (src == null) {
            return JsonNull.createJsonNull();
        }
        return this.toJsonTree(src, src.getClass());
    }

    public JsonElement toJsonTree(Object src, Type typeOfSrc) {
        if (src == null) {
            return JsonNull.createJsonNull();
        }
        JsonSerializationContextDefault context = new JsonSerializationContextDefault(this.createDefaultObjectNavigatorFactory(this.serializationStrategy), this.serializeNulls, this.serializers);
        return context.serialize(src, typeOfSrc, true);
    }

    public String toJson(Object src) {
        if (src == null) {
            return this.serializeNulls ? NULL_STRING : "";
        }
        return this.toJson(src, src.getClass());
    }

    public String toJson(Object src, Type typeOfSrc) {
        StringWriter writer = new StringWriter();
        this.toJson(src, typeOfSrc, writer);
        return writer.toString();
    }

    public void toJson(Object src, Appendable writer) {
        try {
            if (src != null) {
                this.toJson(src, src.getClass(), writer);
            } else if (this.serializeNulls) {
                this.writeOutNullString(writer);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void toJson(Object src, Type typeOfSrc, Appendable writer) {
        JsonElement jsonElement = this.toJsonTree(src, typeOfSrc);
        this.toJson(jsonElement, writer);
    }

    public String toJson(JsonElement jsonElement) {
        StringWriter writer = new StringWriter();
        this.toJson(jsonElement, (Appendable)writer);
        return writer.toString();
    }

    public void toJson(JsonElement jsonElement, Appendable writer) {
        try {
            if (this.generateNonExecutableJson) {
                writer.append(JSON_NON_EXECUTABLE_PREFIX);
            }
            if (jsonElement == null && this.serializeNulls) {
                this.writeOutNullString(writer);
            }
            this.formatter.format(jsonElement, writer, this.serializeNulls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(String json, Class<T> classOfT) throws JsonParseException {
        T target = this.fromJson(json, (Type)classOfT);
        return target;
    }

    public <T> T fromJson(String json, Type typeOfT) throws JsonParseException {
        StringReader reader = new StringReader(json);
        T target = this.fromJson((Reader)reader, typeOfT);
        return target;
    }

    public <T> T fromJson(Reader json, Class<T> classOfT) throws JsonParseException {
        T target = classOfT.cast(this.fromJson(json, (Type)classOfT));
        return target;
    }

    public <T> T fromJson(Reader json, Type typeOfT) throws JsonParseException {
        JsonElement root = new JsonParser().parse(json);
        T target = this.fromJson(root, typeOfT);
        return target;
    }

    public <T> T fromJson(JsonElement json, Class<T> classOfT) throws JsonParseException {
        T target = classOfT.cast(this.fromJson(json, (Type)classOfT));
        return target;
    }

    public <T> T fromJson(JsonElement json, Type typeOfT) throws JsonParseException {
        if (json == null) {
            return null;
        }
        JsonDeserializationContextDefault context = new JsonDeserializationContextDefault(this.createDefaultObjectNavigatorFactory(this.deserializationStrategy), this.deserializers, this.objectConstructor);
        Object target = context.deserialize(json, typeOfT);
        return target;
    }

    private void writeOutNullString(Appendable writer) throws IOException {
        writer.append(NULL_STRING);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{").append("serializeNulls:").append(this.serializeNulls).append(",serializers:").append(this.serializers).append(",deserializers:").append(this.deserializers).append(",instanceCreators:").append(this.objectConstructor).append("}");
        return sb.toString();
    }
}

