/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_ENTRY_H__
#define __GPASS_ENTRY_H__

#include <time.h>
#include <glib.h>
#include <glib-object.h>

#include "gpass/attribute-list.h"

G_BEGIN_DECLS

typedef struct GPassEntry GPassEntry;
typedef struct GPassEntryClass GPassEntryClass;

#define GPASS_TYPE_ENTRY (gpass_entry_get_type())
#define GPASS_ENTRY(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_ENTRY, GPassEntry))
#define GPASS_ENTRY_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_ENTRY, GPassEntryClass))
#define GPASS_IS_ENTRY(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_ENTRY))
#define GPASS_IS_ENTRY_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_ENTRY))
#define GPASS_ENTRY_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_ENTRY, GPassEntryClass))

struct GPassEntry {
    GObject parent;
    
    const gchar *type;
    GNode *node;

    gchar *name;
    gchar *description;
    time_t creation_time;
    time_t modification_time;
    gboolean expiration;
    time_t expiration_time;
};

struct GPassEntryClass {
    GObjectClass parent;
    
    const gchar *(*nick)(void);
    const gchar *(*icon_id)(void);
    const gchar *(*default_launcher)(void);
    gboolean (*can_have_child)(void);
    void (*attributes)(GPassEntryClass *self_class, GPassAttributeList *attrs);
    
    void (*set_attributes)(GPassEntry *self, GPassAttributeList *attrs);
    void (*get_attributes)(GPassEntry *self, GPassAttributeList *attrs);
    gboolean (*include)(GPassEntry *self, const gchar *string);
    gboolean (*equal)(GPassEntry *self, GPassEntry *target);
};

GType gpass_entry_get_type(void);

const gchar *gpass_entry_class_nick(GPassEntryClass *self_class);
const gchar *gpass_entry_class_icon_id(GPassEntryClass *self_class);
const gchar *gpass_entry_class_default_launcher(GPassEntryClass *self_class);
gboolean gpass_entry_class_can_have_child(GPassEntryClass *self_class);
GPassAttributeList *gpass_entry_class_attributes(GPassEntryClass *self_class);

void gpass_entry_set_attributes(GPassEntry *self,
                                GPassAttributeList *attributes);
void gpass_entry_get_attributes(GPassEntry *self,
                                GPassAttributeList *attributes);
void gpass_entry_format(GPassEntry *self, const gchar *format,
                        GString **result);
gboolean gpass_entry_include(GPassEntry *self, const gchar *string);
gboolean gpass_entry_equal(GPassEntry *self, GPassEntry *target);

GPassEntry *gpass_entry_root(GPassEntry *self);
GPassEntry *gpass_entry_parent(GPassEntry *self);
GPassEntry *gpass_entry_prev_sibling(GPassEntry *self);
GPassEntry *gpass_entry_next_sibling(GPassEntry *self);
GPassEntry *gpass_entry_first_child(GPassEntry *self);
gboolean gpass_entry_has_child(GPassEntry *self);

GPassEntry *gpass_entry_insert_before(GPassEntry *parent, GPassEntry *sibling,
                                      GPassEntry *entry);
GPassEntry *gpass_entry_insert_after(GPassEntry *parent, GPassEntry *sibling,
                                     GPassEntry *entry);
#define gpass_entry_prepend(parent, entry) \
    gpass_entry_insert_after(parent, NULL, entry)
#define gpass_entry_append(parent, entry) \
    gpass_entry_insert_before(parent, NULL, entry)
GPassEntry *gpass_entry_unlink(GPassEntry *self);

G_END_DECLS

#endif /* #ifndef __GPASS_ENTRY_H__ */
