/*
 *  Copyright (C) 2004 Morten Fjord-Larsen
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#define ENABLE_BONOBO

#ifdef ENABLE_BONOBO
#include <bonobo/bonobo-main.h>
#include <bonobo/bonobo-application.h>
#endif

#include "gpass/error.h"
#include "gpass/configuration.h"
#include "application.h"

#ifdef ENABLE_BONOBO
static Bonobo_RegistrationResult
register_application(BonoboAppClient **client)
{
    BonoboApplication *app = bonobo_application_new("GNOME_Password_Manager");
    gchar *serverinfo = bonobo_application_create_serverinfo(app, NULL);
    Bonobo_RegistrationResult result =
        bonobo_application_register_unique(app, serverinfo, client);

    g_free(serverinfo);
    bonobo_object_unref(app);
    return result;
}
#endif

#if 0
static gboolean
on_save_yourself(GnomeClient *client, gint phase, GnomeSaveStyle arg2,
                 gboolean arg3, GnomeInteractStyle arg4, gboolean arg5,
                 gpointer user_data)
{
    GPassController *controller =
        (GPassController *) GPASS_CONTROLLER(user_data);

    if (gpass_window_save(controller->window) != NULL) {
        return FALSE;
    }
    return TRUE;
}
#endif

int
main(int argc, char *argv[])
{
    GPassApplication *app;
    GnomeProgram *gnome_program;
    GnomeClient *gnome_client;
    gboolean result;
    GError *error = NULL;

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(PACKAGE);
#endif

#ifdef ENABLE_BONOBO
    bonobo_init(&argc, argv);
    {
        BonoboAppClient *bonobo_app_client = NULL;
        Bonobo_RegistrationResult registration_result = 
            register_application(&bonobo_app_client);
        
        if (registration_result == Bonobo_ACTIVATION_REG_ALREADY_ACTIVE) {
            g_message(_("One instance of GPass is already running."));
            bonobo_object_unref(bonobo_app_client);
            exit(1);
        }
    }
#endif

    gnome_program = gnome_program_init(PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                                       argc, argv,
                                       GNOME_PARAM_POPT_TABLE, NULL,
                                       GNOME_PARAM_NONE);
    glade_gnome_init();
    g_set_application_name(_("Password Manager"));
    gnome_client = gnome_master_client();
    gnome_client_set_restart_style(gnome_client, GNOME_RESTART_IF_RUNNING);
    gnome_client_set_restart_command(gnome_client, argc, argv);

    {
        GPassConfiguration *config = gpass_configuration_instance();
        
        g_object_set(config, "gconf_client", gconf_client_get_default(), NULL);
    }
    app = g_object_new(GPASS_TYPE_APPLICATION, NULL);
    app->view_factory =
        GPASS_VIEW_FACTORY(g_object_new(GPASS_TYPE_VIEW_FACTORY, NULL));
    error = gpass_application_welcome(app, &result);
    if (error != NULL || !result) {
        goto end;
    }
    error = gpass_application_run(app, &result);
 end:
    g_object_unref(app->view_factory);
    g_object_unref(app);
    if (error != NULL) {
        gpass_error_show_and_exit(error);
    }
    gpass_configuration_finalize();
#if 0
    g_signal_connect(gnome_client, "save-yourself",
                     G_CALLBACK(on_save_yourself), user_data);
#endif
    return 0;
}
