#!/bin/bash

cdreader=$1
directory=`echo $2 | sed 's/"//g'`

if [ ! -d "$directory" ] || [ ! -b "$cdreader" ]; then
	echo "usage: $0 cdreader flac|mp3|vorbis|wav directory"
	echo "example: $0 /dev/sr0 wav /home/me/audio"
	exit
fi


source simpleburn-burning-suite quiet


cd "$directory"

if echo $CDDA2WAV | grep -q "cd-paranoia" || echo $CDDA2WAV | grep -q "cdparanoia"
then sectorscount=`$CDDA2WAV -Q -d $cdreader 2>&1 | grep TOTAL | sed 's/ \+/ /g' | cut -f2 -d' '`
	$CDDA2WAV -e -Z -B -d $cdreader 2>&1 | simpleburn-gauges cdparanoia $sectorscount
else trackslenghts=`$CDDA2WAV -N -J -v toc dev=$cdreader 2>&1 | sed -n '/(/p' | sed 's/[0-9]*\.( //g' | sed 's/\.[0-9]*)//g' | sed 's/,//g'`
	audiosizes=""
	for tracklength in $trackslenghts; do
		minutes=`echo $tracklength | cut -f1 -d: | sed 's/^0*//'`
		seconds=`echo $tracklength | cut -f2 -d: | sed 's/^0*//'`
		let seconds=(minutes*60)+seconds
		audiosizes="$audiosizes$seconds "
	done
	$CDDA2WAV -L1 dev=$cdreader -B "$directory"/audio 2>&1 | simpleburn-gauges cdda2wav $audiosizes
fi

#renaming
if [ -f "$directory"/audio.cddb ]
then ls "$directory"/*.inf | while read trackinfofile; do 
		tracknumber=` echo $trackinfofile | sed 's/^.*_\([0-9]*\).inf$/\1/'`
		albumtitle=`cat $trackinfofile | grep "Albumtitle" | sed 's/.*=\t//' | sed s@/@-@g`
		tracktitle=`cat $trackinfofile | grep "Tracktitle" | sed 's/.*=\t//' | sed s@/@-@g`
		mv "$directory"/audio_$tracknumber.wav "$directory"/"$albumtitle"-$tracknumber-"$tracktitle".wav
		mv "$directory"/audio_$tracknumber.inf "$directory"/"$albumtitle"-$tracknumber-"$tracktitle".inf
	done
	rm -f "$directory"/audio.{cdindex,cddb}
fi

cd - >/dev/null
