#!/bin/bash

device=$1
if [ -z $device ]; then
	echo "usage: $0 device"
	echo "example: $0 /dev/sr0"
	exit
fi

udi=`hal-find-by-property --key block.device --string $device | grep volume`
if [ ! -z "$udi" ]
then
	mediatype=`hal-get-property --udi $udi --key volume.disc.type | cut -f1 -d_`
	
	mediacontent=`hal-get-property --udi $udi --key volume.fstype`
	if [ `hal-get-property --udi $udi --key volume.disc.has_audio` == "true" ]
	then mediacontent="audio"
	fi
	if [ -z "$mediacontent" ]
	then mediacontent="blank"
	fi
	
	mediacapacity=`hal-get-property --udi $udi --key volume.disc.capacity`
	let mediacapacity=mediacapacity/1024
	
	if [ "$mediacontent" == "blank" ]
	then mediasize=0
	else	if [ "$mediatype" == "dvd" ] && [ "$mediacontent" == "iso9660" ]
		then mediasize=`isosize -d 1024 $device`
		else	mediasize=`hal-get-property --udi $udi --key volume.size`
			let mediasize=mediasize/1024
		fi
	fi
	
	rewritablemedia=`hal-get-property --udi $udi --key volume.disc.is_rewritable`
	if [ "$rewritablemedia" == "true" ]
	then rewritablemedia=1
	else rewritablemedia=0
	fi
	
	if [ "$mediatype" == "cd" ] && [ "$mediacontent" != "blank" ] || [ "$rewritablemedia" == "0" ] && [ "$mediacontent" != "blank" ]
	then mediacapacity=0
	fi
	
	if [ "$2" == "oneline" ]
	then echo "$mediatype:$mediacontent:$mediacapacity:$mediasize:$rewritablemedia"
	else	echo "mediatype=$mediatype"
		echo "mediacontent=$mediacontent" #KiB
		echo "mediacapacity=$mediacapacity"
		echo "mediasize=$mediasize"
		echo "rewritablemedia=$rewritablemedia"
	fi
	exit 0
else exit 1
fi

