#!/bin/bash

device=$1
if [ -z $device ]; then
	echo "usage: $0 device"
	echo "example: $0 /dev/sr0"
	exit
fi


CDRECORD=`which cdrecord 2>/dev/null || which wodim 2>/dev/null || which cdrskin 2>/dev/null`
#~ CDDA2WAV=`which cdda2wav 2>/dev/null || which icedax 2>/dev/null`


function getdevicefstypeandsize () {
	if df | grep -q "$device "
	then mediasize=`df | grep "$device " | sed 's/ \+/ /g' | cut -f3 -d' '`
		fstype=`mount | grep "$device " | cut -f5 -d' '`
	else if mount $device 2>/dev/null
		then mediasize=`df | grep "$device " | sed 's/ \+/ /g' | cut -f3 -d' '`
			fstype=`mount | grep "$device " | cut -f5 -d' '`
			umount $device 2>/dev/null
		fi
	fi
	echo "$fstype:$mediasize"
}


if /lib/udev/cdrom_id $device | grep -q "ID_CDROM_MEDIA"
then 
	if /lib/udev/cdrom_id $device | grep -q "ID_CDROM_MEDIA_DVD"
	then mediatype="dvd"
	else if /lib/udev/cdrom_id $device | grep -q "ID_CDROM_MEDIA_CD"
		then mediatype="cd"
		else exit 1
		fi
	fi
	
	fstypeandsize=`getdevicefstypeandsize`
	if [ "$fstypeandsize" == ":" ]
	then mediacontent="blank"
		mediasize=0
	else mediacontent=`echo $fstypeandsize | cut -f1 -d:`
		mediasize=`echo $fstypeandsize | cut -f2 -d:`
	fi
	
	if [ "$mediatype" == "cd" ]
	then
		if /lib/udev/cdrom_id $device | grep -q "ID_CDROM_MEDIA_CD_RW"
		then rewritablemedia=1
		else rewritablemedia=0
		fi
		
		if /lib/udev/cdrom_id $device | grep -q "ID_CDROM_MEDIA_TRACK_COUNT_AUDIO"
		then mediacontent="audio" #overrides "data" if it is an hybrid CD
			#~ mediasize=`$CDDA2WAV -N -J -v sectors dev=$device 2>&1 | grep "lead-out" | sed 's/.*lead-out( *\([0-9]\+\))/\1/'`
			mediasize=`$CDRECORD -toc dev=$device 2>&1 | grep "track:lout" | sed 's/track:lout lba: \+\([0-9]\+\) .*/\1/'`
			let mediasize=mediasize*2
		fi
		
		if /lib/udev/cdrom_id $device | grep -q "ID_CDROM_MEDIA_CD_R"
		then mediacapacity=`$CDRECORD -atip dev=$device 2>&1 | grep "ATIP start of lead out:" | sed 's/.*: \([0-9]\+\) .*/\1/'` 
			let mediacapacity=mediacapacity*2
		else mediacapacity=0
		fi
	else #DVD
		if /lib/udev/cdrom_id $device | grep -q "ID_CDROM_MEDIA_DVD.*RW"
		then rewritablemedia=1
		else rewritablemedia=0
		fi
		
		if /lib/udev/cdrom_id $device | grep -q "ID_CDROM_MEDIA_DVD.*R"
		#~ then mediacapacity=`dvd+rw-mediainfo $device | grep "Legacy lead-out at:" | cut -f2 -d=`
			#~ let mediacapacity=mediacapacity/1024
		then mediacapacity=`$CDRECORD -atip dev=$device 2>&1 | grep "rzone size:" | tail -1 | sed 's/rzone size: \+//'` #doesn't work with wodim or cdrskin => mediacapacity = 0 (unknown)
			let mediacapacity=mediacapacity*2
		else mediacapacity=0
		fi
	fi
	
	if [ "$2" == "oneline" ]
	then echo "$mediatype:$mediacontent:$mediacapacity:$mediasize:$rewritablemedia"
	else	echo "mediatype=$mediatype"
		echo "mediacontent=$mediacontent" #KiB
		echo "mediacapacity=$mediacapacity"
		echo "mediasize=$mediasize"
		echo "rewritablemedia=$rewritablemedia"
	fi
	exit 0
else	exit 1
fi
