#include <stdio.h>

#include <cdio/cdio.h>
#include <cdio/cd_types.h>
#include <cdio/mmc.h>
#include <cdio/iso9660.h>

//for glib compliance (see "t_cdinfos.h")
typedef char gchar;
typedef bool gboolean;
typedef unsigned long long guint64;
#define FALSE 0
#define TRUE 1

#include "t_cdinfos.h"

//temporary untill libcdio inclusion
#include <stdlib.h>
#include <string.h>
#include "libcdio-cmds.c"
#include "libcdio-disctype.c"
//~ #include "libcdio-hli.c"


int main (int argc, char *argv[]) {
	T_cdinfos cdinfos;
	gchar *device;
	CdIo_t *cdio;
	cdio_fs_anal_t fs;
	int i;
	cdio_iso_analysis_t cdio_iso_analysis; 
	_disctype_t disctype;
	iso9660_t *iso;
	iso9660_pvd_t pvd;
	
	//for output only
	gchar mediatype[4];
	gchar mediacontent[8];
	
	if (argc == 1) {
		printf ("usage: %s device\nexample: %s /dev/sr0\n", argv[0], argv[0]);
		return;
	} else
		device = argv[1];
	
	cdinfos.hasmedia = FALSE;
	cdinfos.hasrewritablemedia = FALSE;
	cdinfos.hascdrommedia = FALSE;
	cdinfos.hasdvdmedia = FALSE;
	cdinfos.hasemptymedia = FALSE;
	cdinfos.hasaudiocdmedia = FALSE;
	cdinfos.hasdatamedia = FALSE;
	cdinfos.hasiso9660media = FALSE;
	cdinfos.hasudfmedia = FALSE;
	cdinfos.mediasize = 0;
	cdinfos.mediacapacity = 0;
	
	cdio = cdio_open (device, DRIVER_UNKNOWN);
	disctype = _mmc_get_disctype (cdio, NULL);
	
	if (_mmc_is_disctype_cdrom (disctype) || _mmc_is_disctype_dvd (disctype)) { //if there is a CD or DVD media
		cdinfos.hasmedia = TRUE;
		
		if (_mmc_is_disctype_cdrom (disctype)) {
			cdinfos.hascdrommedia = TRUE;
			sprintf (mediatype, "cd");
		} else {
			cdinfos.hasdvdmedia = TRUE;
			sprintf (mediatype, "dvd");
		}
	
		if (_mmc_is_disctype_rewritable (disctype))
			cdinfos.hasrewritablemedia = TRUE;
		
		cdinfos.mediacapacity = _mmc_get_disc_capacity (cdio, NULL);
		if (_mmc_get_disc_empty (cdio, NULL)) {
			sprintf (mediacontent, "blank");
			cdinfos.hasemptymedia = TRUE;
			cdinfos.mediasize = 0;
		} else {
			cdinfos.mediasize = cdio_get_disc_last_lsn (cdio) * 2;
			fs = cdio_guess_cd_type (cdio, 0, 1, &cdio_iso_analysis);
			if (CDIO_FSTYPE (fs) == CDIO_FS_AUDIO) {
				sprintf (mediacontent, "audio");
				cdinfos.hasaudiocdmedia = true;
			} else {
				if (CDIO_FSTYPE (fs) == CDIO_FS_ISO_9660) {
					sprintf (mediacontent, "iso9660");
					cdinfos.hasdatamedia = TRUE;
					cdinfos.hasiso9660media = TRUE;
					iso = iso9660_open (device);
					if (iso9660_ifs_read_pvd (iso, &pvd)) {
						if (pvd.volume_space_size * 2 < cdinfos.mediasize) //WORKAROUND
							cdinfos.mediasize = pvd.volume_space_size * 2;
					} else
						cdinfos.mediasize = 0;
					iso9660_close (iso);

				} else {
					if (CDIO_FSTYPE (fs) == CDIO_FS_UDF || CDIO_FSTYPE (fs) == CDIO_FS_ISO_UDF) {
						sprintf (mediacontent, "udf");
						cdinfos.hasdatamedia = TRUE;
						cdinfos.hasudfmedia = TRUE;
						cdinfos.mediacapacity = cdinfos.mediasize;
					} else {
						sprintf (mediacontent, "blank");
						cdinfos.hasemptymedia = TRUE;
						cdinfos.mediasize = 0;
					}
				}
			}
		}
		
		if (_mmc_is_disctype_cdrom (disctype) && ! cdinfos.hasemptymedia || ! cdinfos.hasemptymedia && ! cdinfos.hasrewritablemedia)
			cdinfos.mediacapacity = 0;
		
		if (argc == 3 && strncmp (argv[2], "oneline", 8) == 0)
		    printf ("%s:%s:%llu:%llu:%d\n", mediatype, mediacontent, cdinfos.mediacapacity, cdinfos.mediasize, cdinfos.hasrewritablemedia);
		else	
		    printf ("mediatype=%s\nmediacontent=%s\nmediacapacity=%llu\nmediasize=%llu\nrewritablemedia=%d\n", 
			mediatype, mediacontent, cdinfos.mediacapacity, cdinfos.mediasize, cdinfos.hasrewritablemedia);
		
		cdio_destroy (cdio);
		return 0;
	} else {
		cdio_destroy (cdio);
		return 1;
	}
	
}
