/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;

public class LameFrame {
    public static final int LAME_HEADER_BUFFER_SIZE = 36;
    public static final int ENCODER_SIZE = 9;
    public static final int LAME_ID_SIZE = 4;
    public static final String LAME_ID = "LAME";
    private String encoder;

    private LameFrame(ByteBuffer lameHeader) {
        this.encoder = Utils.getString(lameHeader, 0, 9, "ISO-8859-1");
    }

    public static LameFrame parseLameFrame(ByteBuffer bb) {
        ByteBuffer lameHeader = bb.slice();
        String id = Utils.getString(lameHeader, 0, 4, "ISO-8859-1");
        lameHeader.rewind();
        if (id.equals(LAME_ID)) {
            LameFrame lameFrame = new LameFrame(lameHeader);
            return lameFrame;
        }
        return null;
    }

    public String getEncoder() {
        return this.encoder;
    }
}

