/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Manager;
import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.commands.CommandExecuter;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.events.LatestVersionEvent;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class Console
implements Manager {
    private static final Logger log = Logger.getLogger(Console.class);
    protected static final String CMD_COLADD = "coladd";
    protected static final String CMD_COLDEL = "coldel";
    protected static final String CMD_COLLIST = "collist";
    protected static final String CMD_COLSCAN = "colscan";
    protected static final String CMD_EXIT = "exit";
    protected static final String CMD_PROPSET = "propset";
    protected static final String CMD_PROPLIST = "proplist";
    protected static final String CMD_PROPDEL = "propdel";
    protected static final String CMD_USERLIST = "userlist";
    protected static final String CMD_USERADD = "useradd";
    protected static final String CMD_USERDEL = "userdel";
    protected static final String CMD_USERADMIN = "useradmin";
    protected static final String CMD_VERSION = "version";
    private final Database db;
    private final Properties p;
    private final CollectionManager cm;
    private final Locale locale;
    private final PrintStream out;
    private final InputStream is;
    private static final String PROMPT = "#SoCkSo#> ";

    public Console(Database db, Properties p, CollectionManager cm, Locale locale) {
        this(db, p, cm, System.out, System.in, locale);
    }

    public Console(Database db, Properties p, CollectionManager cm, PrintStream out, InputStream is, Locale locale) {
        this.db = db;
        this.p = p;
        this.cm = cm;
        this.out = out;
        this.is = is;
        this.locale = locale;
    }

    public void latestVersionReceived(LatestVersionEvent evt) {
        String latestVersion = evt.getVersion();
        if (latestVersion != null && !latestVersion.equals("1.3.3")) {
            this.out.println(this.locale.getString("misc.msg.updateAvailable", new String[]{latestVersion}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() {
        CommandExecuter cmd = new CommandExecuter(this.db, this.p, this.cm, this.locale);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(this.is));
            while (true) {
                this.out.print(PROMPT);
                String command = in.readLine();
                if (command == null) break;
                this.out.println(cmd.execute(command));
                continue;
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            Utils.close(in);
            return;
        }
        catch (Throwable throwable) {
            Utils.close(in);
            throw throwable;
        }
        Utils.close(in);
    }

    public void close() {
    }
}

