/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.commands;

import com.pugh.sockso.Utils;
import com.pugh.sockso.commands.BaseCommand;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.resources.Locale;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class UserAdmin
extends BaseCommand {
    private Database db;
    private Locale locale;
    private static final Logger log = Logger.getLogger(UserAdmin.class);

    public UserAdmin(Database db, Locale locale) {
        this.db = db;
        this.locale = locale;
    }

    public String getName() {
        return "useradmin";
    }

    public String getDescription() {
        return "Sets a user to be admin/non-admin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String[] args) {
        String string;
        PreparedStatement st = null;
        if (!args[2].matches("1|0")) {
            return this.locale.getString("con.err.errorUpdatingUser");
        }
        int id = Integer.parseInt(args[1]);
        int isAdmin = Integer.parseInt(args[2]);
        String sql = " update users  set is_admin = ?  where id = ? ";
        try {
            st = this.db.prepare(" update users  set is_admin = ?  where id = ? ");
            st.setInt(1, isAdmin);
            st.setInt(2, id);
            string = st.executeUpdate() == 1 ? this.locale.getString("con.msg.userUpdated") : this.locale.getString("con.err.errorUpdatingUser");
        }
        catch (SQLException e) {
            String string2;
            try {
                log.error((Object)e);
                string2 = this.locale.getString("com.err.errorUpdatingUser");
            }
            catch (Throwable throwable) {
                Utils.close(st);
                throw throwable;
            }
            Utils.close(st);
            return string2;
        }
        Utils.close(st);
        return string;
    }

    public int getNumArgs() {
        return 2;
    }

    public String[] getArguments() {
        return new String[]{"ID", "ISADMIN 1/0"};
    }
}

