/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.commands;

import com.pugh.sockso.Utils;
import com.pugh.sockso.commands.BaseCommand;
import com.pugh.sockso.db.Database;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UserList
extends BaseCommand {
    private final Database db;

    public UserList(Database db) {
        this.db = db;
    }

    public String getName() {
        return "userlist";
    }

    public String getDescription() {
        return "Lists the users";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String[] args) throws SQLException {
        String string;
        StringBuffer sb = new StringBuffer();
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " select id, name, email, is_admin, is_active  from users  order by name asc ";
            st = this.db.prepare(" select id, name, email, is_admin, is_active  from users  order by name asc ");
            rs = st.executeQuery();
            while (rs.next()) {
                sb.append(rs.getString("id"));
                sb.append("\t");
                sb.append(rs.getString("name"));
                sb.append("\t");
                sb.append(rs.getString("email"));
                sb.append("\t");
                sb.append(rs.getBoolean("is_admin") ? "ADMIN" : "");
                sb.append("\t");
                sb.append(rs.getInt("is_active") == 1 ? "" : "PENDING");
                sb.append("\n");
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return string;
    }

    public int getNumArgs() {
        return 0;
    }
}

