/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.Properties;
import com.pugh.sockso.commands.CommandExecuter;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ConsoleFrame
extends JFrame {
    private static final Logger log = Logger.getLogger(ConsoleFrame.class);
    private static final int MAX_OUTPUT_LENGTH = 5000;
    private final CommandExecuter cmd;
    private final Resources r;
    private JTextField inputField;
    protected JTextArea outputArea;
    private JButton commandButton;
    private JButton hideButton;

    public ConsoleFrame(Database db, Properties p, CollectionManager cm, Resources r) {
        super(r.getCurrentLocale().getString("gui.window.console"));
        this.r = r;
        this.cmd = new CommandExecuter(db, p, cm, r.getCurrentLocale());
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        Locale locale = this.r.getCurrentLocale();
        this.inputField = new JTextField();
        this.inputField.addActionListener(this.getConsoleCommandAction());
        this.outputArea = new JTextArea();
        this.outputArea.setEditable(false);
        this.outputArea.setFont(new Font("Courier", 0, 12));
        this.commandButton = new JButton(locale.getString("gui.label.consoleCommandGo"), new ImageIcon(this.r.getImage("icons/22x22/execute.png")));
        this.commandButton.addActionListener(this.getConsoleCommandAction());
        this.hideButton = new JButton(locale.getString("gui.label.hide"), new ImageIcon(this.r.getImage("icons/22x22/hide.png")));
        this.hideButton.addActionListener(this.getHideButtonAction());
    }

    private void layoutComponents() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.commandButton);
        buttonPanel.add(this.hideButton);
        JPanel commandPanel = new JPanel();
        commandPanel.setLayout(new BorderLayout());
        commandPanel.add((Component)this.inputField, "Center");
        commandPanel.add((Component)buttonPanel, "East");
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)new JScrollPane(this.outputArea), "Center");
        c.add((Component)commandPanel, "South");
    }

    private ActionListener getConsoleCommandAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    String newText = ConsoleFrame.this.outputArea.getText() + ConsoleFrame.this.cmd.execute(ConsoleFrame.this.inputField.getText()) + "\n\n";
                    int len = newText.length();
                    int start = len > 5000 ? len - 5000 : 0;
                    ConsoleFrame.this.outputArea.setText(newText.substring(start, len) + "\n");
                    ConsoleFrame.this.inputField.setText("");
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        };
    }

    private ActionListener getHideButtonAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConsoleFrame.this.setVisible(false);
            }
        };
    }
}

