/* spek-message-bar.c generated by valac 0.10.4, the Vala compiler
 * generated from spek-message-bar.vala, do not modify */

/* spek-message-bar.vala
 *
 * Copyright (C) 2010  Alexander Kojevnikov <alexander@kojevnikov.com>
 *
 * Spek is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Spek is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Spek.  If not, see <http://www.gnu.org/licenses/>.
 *
 * This class is heavily influenced by its namesake from Banshee.
 * The original code by Aaron Bockover is (c) 2008 Novell, Inc.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <spek-platform.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define SPEK_TYPE_MESSAGE_BAR (spek_message_bar_get_type ())
#define SPEK_MESSAGE_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_MESSAGE_BAR, SpekMessageBar))
#define SPEK_MESSAGE_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_MESSAGE_BAR, SpekMessageBarClass))
#define SPEK_IS_MESSAGE_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_MESSAGE_BAR))
#define SPEK_IS_MESSAGE_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_MESSAGE_BAR))
#define SPEK_MESSAGE_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_MESSAGE_BAR, SpekMessageBarClass))

typedef struct _SpekMessageBar SpekMessageBar;
typedef struct _SpekMessageBarClass SpekMessageBarClass;
typedef struct _SpekMessageBarPrivate SpekMessageBarPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _SpekMessageBar {
	GtkHBox parent_instance;
	SpekMessageBarPrivate * priv;
};

struct _SpekMessageBarClass {
	GtkHBoxClass parent_class;
};

struct _SpekMessageBarPrivate {
	GtkLabel* label;
	GtkWindow* win;
	gboolean changing_style;
};


static gpointer spek_message_bar_parent_class = NULL;

GType spek_message_bar_get_type (void) G_GNUC_CONST;
#define SPEK_MESSAGE_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPEK_TYPE_MESSAGE_BAR, SpekMessageBarPrivate))
enum  {
	SPEK_MESSAGE_BAR_DUMMY_PROPERTY
};
SpekMessageBar* spek_message_bar_new (const char* message);
SpekMessageBar* spek_message_bar_construct (GType object_type, const char* message);
static void _lambda0_ (SpekMessageBar* self);
static void __lambda0__gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self);
static gboolean _lambda1_ (const char* uri, SpekMessageBar* self);
static gboolean __lambda1__gtk_label_activate_link (GtkLabel* _sender, const char* uri, gpointer self);
static void _lambda2_ (SpekMessageBar* self);
static void __lambda2__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void spek_message_bar_real_style_set (GtkWidget* base, GtkStyle* previous_style);
static gboolean spek_message_bar_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static void spek_message_bar_finalize (GObject* obj);



static void _lambda0_ (SpekMessageBar* self) {
	gtk_widget_set_style ((GtkWidget*) self, gtk_widget_get_style ((GtkWidget*) self->priv->win));
}


static void __lambda0__gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self) {
	_lambda0_ (self);
}


static gboolean _lambda1_ (const char* uri, SpekMessageBar* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (uri != NULL, FALSE);
	spek_platform_show_uri (uri);
	result = TRUE;
	return result;
}


static gboolean __lambda1__gtk_label_activate_link (GtkLabel* _sender, const char* uri, gpointer self) {
	gboolean result;
	result = _lambda1_ (uri, self);
	return result;
}


static void _lambda2_ (SpekMessageBar* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void __lambda2__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda2_ (self);
}


SpekMessageBar* spek_message_bar_construct (GType object_type, const char* message) {
	SpekMessageBar * self;
	GtkWindow* _tmp0_;
	GtkLabel* _tmp1_;
	GtkHBox* button_box;
	GtkButton* close_button;
	GtkImage* _tmp2_;
	g_return_val_if_fail (message != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtk_box_set_homogeneous ((GtkBox*) self, FALSE);
	gtk_box_set_spacing ((GtkBox*) self, 0);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 6);
	self->priv->win = (_tmp0_ = g_object_ref_sink ((GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP)), _g_object_unref0 (self->priv->win), _tmp0_);
	gtk_widget_set_name ((GtkWidget*) self->priv->win, "gtk-tooltips");
	gtk_widget_ensure_style ((GtkWidget*) self->priv->win);
	g_signal_connect_object ((GtkWidget*) self->priv->win, "style-set", (GCallback) __lambda0__gtk_widget_style_set, self, 0);
	self->priv->label = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL)), _g_object_unref0 (self->priv->label), _tmp1_);
	gtk_label_set_use_markup (self->priv->label, TRUE);
	gtk_label_set_markup (self->priv->label, message);
	gtk_label_set_ellipsize (self->priv->label, PANGO_ELLIPSIZE_END);
	g_object_set ((GtkMisc*) self->priv->label, "xalign", 0.f, NULL);
	g_signal_connect_object (self->priv->label, "activate-link", (GCallback) __lambda1__gtk_label_activate_link, self, 0);
	button_box = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
	gtk_box_set_spacing ((GtkBox*) button_box, 3);
	close_button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	gtk_button_set_image (close_button, (GtkWidget*) (_tmp2_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU))));
	_g_object_unref0 (_tmp2_);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	g_signal_connect_object (close_button, "clicked", (GCallback) __lambda2__gtk_button_clicked, self, 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->label, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) button_box, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (close_button);
	_g_object_unref0 (button_box);
	return self;
}


SpekMessageBar* spek_message_bar_new (const char* message) {
	return spek_message_bar_construct (SPEK_TYPE_MESSAGE_BAR, message);
}


static void spek_message_bar_real_style_set (GtkWidget* base, GtkStyle* previous_style) {
	SpekMessageBar * self;
	self = (SpekMessageBar*) base;
	if (self->priv->changing_style) {
		return;
	}
	self->priv->changing_style = TRUE;
	gtk_widget_set_style ((GtkWidget*) self, gtk_widget_get_style ((GtkWidget*) self->priv->win));
	gtk_widget_set_style ((GtkWidget*) self->priv->label, gtk_widget_get_style ((GtkWidget*) self));
	self->priv->changing_style = FALSE;
}


static gboolean spek_message_bar_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SpekMessageBar * self;
	gboolean result = FALSE;
	cairo_t* cr;
	GdkColor color;
	self = (SpekMessageBar*) base;
	if (!GTK_WIDGET_DRAWABLE ((GtkWidget*) self)) {
		result = FALSE;
		return result;
	}
	cr = gdk_cairo_create ((GdkDrawable*) (*event).window);
	color = gtk_widget_get_style ((GtkWidget*) self)->bg[GTK_STATE_NORMAL];
	cairo_set_source_rgb (cr, color.red / 65535.0, color.green / 65535.0, color.blue / 65535.0);
	cairo_rectangle (cr, (double) ((GtkWidget*) self)->allocation.x, (double) ((GtkWidget*) self)->allocation.y, (double) ((GtkWidget*) self)->allocation.width, (double) ((GtkWidget*) self)->allocation.height);
	cairo_fill (cr);
	result = GTK_WIDGET_CLASS (spek_message_bar_parent_class)->expose_event ((GtkWidget*) GTK_HBOX (self), event);
	_cairo_destroy0 (cr);
	return result;
}


static void spek_message_bar_class_init (SpekMessageBarClass * klass) {
	spek_message_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SpekMessageBarPrivate));
	GTK_WIDGET_CLASS (klass)->style_set = spek_message_bar_real_style_set;
	GTK_WIDGET_CLASS (klass)->expose_event = spek_message_bar_real_expose_event;
	G_OBJECT_CLASS (klass)->finalize = spek_message_bar_finalize;
}


static void spek_message_bar_instance_init (SpekMessageBar * self) {
	self->priv = SPEK_MESSAGE_BAR_GET_PRIVATE (self);
	self->priv->changing_style = FALSE;
}


static void spek_message_bar_finalize (GObject* obj) {
	SpekMessageBar * self;
	self = SPEK_MESSAGE_BAR (obj);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->win);
	G_OBJECT_CLASS (spek_message_bar_parent_class)->finalize (obj);
}


GType spek_message_bar_get_type (void) {
	static volatile gsize spek_message_bar_type_id__volatile = 0;
	if (g_once_init_enter (&spek_message_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpekMessageBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spek_message_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpekMessageBar), 0, (GInstanceInitFunc) spek_message_bar_instance_init, NULL };
		GType spek_message_bar_type_id;
		spek_message_bar_type_id = g_type_register_static (GTK_TYPE_HBOX, "SpekMessageBar", &g_define_type_info, 0);
		g_once_init_leave (&spek_message_bar_type_id__volatile, spek_message_bar_type_id);
	}
	return spek_message_bar_type_id__volatile;
}




